/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report;

// Java classes

// Library classes

// Framework classes

// ESR classes

/**
 * An exception to indicate an invalid report template. A 
 * report template is in XML format so this exception could 
 * be triggered due to an invalid format, an invalid path,
 * or an invalid XML syntax. 
 *
 * Project: Framework</br>
 * Created on: 10:36:26 AM </br>
 *
 * @author DNS   LEV
 */
public class InvalidTemplateException extends ReportException {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3749893340788448053L;

	/**
	 * A default constructor
	 */
	public InvalidTemplateException() {
		super();
	}

	/**
	 * A default constructor
	 * @param message
	 */
	public InvalidTemplateException(String message) {
		super(message);
	}

	/**
	 * A default constructor
	 * @param message
	 * @param t
	 */
	public InvalidTemplateException(String message, Throwable t) {
		super(message, t);
	}

	/**
	 * A default constructor
	 * @param t
	 */
	public InvalidTemplateException(Throwable t) {
		super(t);
	}
}
