/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report;

// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.service.ServiceException;

// Framework classes
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.service.AbstractComponent;

/**
 * A generic service to generate a report.  
 *
 * Project: Framework</br>
 * Created on: 9:39:43 AM </br>
 *
 * @author DNS   LEV
 */
public class ConfigurableReportService extends AbstractComponent implements ReportService {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8797762279261939713L;

	private ReportService reportService = null;
	
	/**
	 * A default constructor
	 */
	public ConfigurableReportService() {
		super();
	}

	/** Generates a report using the specific report configuration.
	 * Use this method to generate a report that already has a well
	 * statically defined report criteria set, and report template.
	 * A report criteria set is used to query report data to populate
	 * a report template. 
	 * 
	 * @param configuration A report configuration
	 * @return Report that encapsulates the actual formatted report
	 */
	public void generateReport( ReportConfiguration configuration ) throws ServiceException {
		this.reportService.generateReport( configuration );
	}
	
	/** Generates a report using the specific report configuration and data
	 * 
	 * @param configuration A report configuration 
	 * @param data Data to generate a report
	 * @return Report that encapsulates the actual formatted report
	 */
	public void generateReport( ReportConfiguration configuration, ReportData data ) throws ServiceException {
		this.reportService.generateReport( configuration, data );
	}

	/**
	 * @param reportService The reportService to set.
	 */
	public void setReportService( ReportService reportService ) {
		this.reportService = reportService;
	}

	/**
	 * @see gov.va.med.fw.service.AbstractComponent#afterPropertiesSet()
	 */
	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
		Validate.notNull( this.reportService, "A report processor service must not be NULL" );
	}
}