/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report;

// Java classes
import java.io.ByteArrayOutputStream;

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.service.AbstractComponent;

// ESR classes

/**
 * 
 *
 * Project: Framework</br>
 * Created on: 2:00:45 PM </br>
 *
 * @author DNS   LEV
 */
public abstract class AbstractReportExporter extends AbstractComponent implements ReportExporter {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 1467885659349836403L;

	/**
	 * An instance of reportPersister
	 */
	private ReportPersister reportPersister = null;
	
	/**
	 * A default constructor
	 */
	protected AbstractReportExporter() {
		super();
		this.setReportPersister( new FileSystemReportPersister() );
	}

	/**
	 * @return Returns the reportPersister.
	 */
	public ReportPersister getReportPersister() {
		return reportPersister;
	}

	/**
	 * @param reportPersister The reportPersister to set.
	 */
	public void setReportPersister(ReportPersister reportPersister) {
		this.reportPersister = reportPersister;
	}

	/**
	 * @see gov.va.med.fw.report.ReportExporter#exportReport(gov.va.med.fw.report.ReportConfiguration, gov.va.med.fw.report.data.ReportData, gov.va.med.fw.report.ReportTemplate)
	 */
	public void exportReport( ReportConfiguration configuration, ReportData data, ReportTemplate template ) throws ReportException {
		
		Validate.notNull( configuration, "A report configuration must not be NULL" );
		Validate.notNull( data, "A report data must not be NULL " );

		persist( configuration, export( fill( configuration, data, template ) ) );
	}
	
	/**
	 * @param config
	 * @param stream
	 * @throws ReportException
	 */
	protected void persist( ReportConfiguration config, ByteArrayOutputStream stream ) throws ReportException {
		
		if( this.reportPersister != null ) {
			this.reportPersister.persist( config, stream );
		}
	}
	
	/**
	 * @param report
	 * @return
	 * @throws ReportException
	 */
	protected abstract ByteArrayOutputStream export( Object report ) throws ReportException;

	/**
	 * @param config
	 * @param data
	 * @param template
	 * @return
	 * @throws ReportException
	 */
	protected abstract Object fill( ReportConfiguration config, ReportData data, ReportTemplate template ) throws ReportException;
}