/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.persistent.hibernate;

// Java classes
import java.io.Serializable;
import java.util.Iterator;

// Library classes
import org.hibernate.CallbackException;
import org.hibernate.EntityMode;
import org.hibernate.Interceptor;
import org.hibernate.Transaction;
import org.hibernate.type.Type;

// Framework classes
import gov.va.med.fw.service.AbstractComponent;

// ESR classes

/**
 * Provides empty implementation for a hibernate interceptor
 *
 * Project: Framework</br>
 * Created on: 1:43:56 PM </br>
 *
 * @author DNS   LEV
 */
public class PersistentInterceptorAdapter extends AbstractComponent implements Interceptor {

	/**
	 * A default constructor
	 */
	public PersistentInterceptorAdapter() {
		super();
	}

	/**
	 * @see org.hibernate.Interceptor#onLoad(java.lang.Object, java.io.Serializable, java.lang.Object[], java.lang.String[], org.hibernate.type.Type[])
	 */
	public boolean onLoad(Object arg0, Serializable arg1, Object[] arg2,
			String[] arg3, Type[] arg4) throws CallbackException {
		return false;
	}

	/**
	 * @see org.hibernate.Interceptor#onFlushDirty(java.lang.Object, java.io.Serializable, java.lang.Object[], java.lang.Object[], java.lang.String[], org.hibernate.type.Type[])
	 */
	public boolean onFlushDirty(Object arg0, Serializable arg1, Object[] arg2,
			Object[] arg3, String[] arg4, Type[] arg5) throws CallbackException {
		return false;
	}

	/**
	 * @see org.hibernate.Interceptor#onSave(java.lang.Object, java.io.Serializable, java.lang.Object[], java.lang.String[], org.hibernate.type.Type[])
	 */
	public boolean onSave(Object arg0, Serializable arg1, Object[] arg2,
			String[] arg3, Type[] arg4) throws CallbackException {
		return false;
	}

	/**
	 * @see org.hibernate.Interceptor#onDelete(java.lang.Object, java.io.Serializable, java.lang.Object[], java.lang.String[], org.hibernate.type.Type[])
	 */
	public void onDelete(Object arg0, Serializable arg1, Object[] arg2,
			String[] arg3, Type[] arg4) throws CallbackException {
	}

	/**
	 * @see org.hibernate.Interceptor#onCollectionRecreate(java.lang.Object, java.io.Serializable)
	 */
	public void onCollectionRecreate(Object arg0, Serializable arg1)
			throws CallbackException {
	}

	/**
	 * @see org.hibernate.Interceptor#onCollectionRemove(java.lang.Object, java.io.Serializable)
	 */
	public void onCollectionRemove(Object arg0, Serializable arg1)
			throws CallbackException {
	}

	/**
	 * @see org.hibernate.Interceptor#onCollectionUpdate(java.lang.Object, java.io.Serializable)
	 */
	public void onCollectionUpdate(Object arg0, Serializable arg1)
			throws CallbackException {
	}

	/**
	 * @see org.hibernate.Interceptor#preFlush(java.util.Iterator)
	 */
	public void preFlush(Iterator arg0) throws CallbackException {
	}

	/**
	 * @see org.hibernate.Interceptor#postFlush(java.util.Iterator)
	 */
	public void postFlush(Iterator arg0) throws CallbackException {
	}

	/**
	 * @see org.hibernate.Interceptor#isTransient(java.lang.Object)
	 */
	public Boolean isTransient(Object arg0) {
		return null;
	}

	/**
	 * @see org.hibernate.Interceptor#findDirty(java.lang.Object, java.io.Serializable, java.lang.Object[], java.lang.Object[], java.lang.String[], org.hibernate.type.Type[])
	 */
	public int[] findDirty(Object arg0, Serializable arg1, Object[] arg2,
			Object[] arg3, String[] arg4, Type[] arg5) {
		return null;
	}

	/**
	 * @see org.hibernate.Interceptor#instantiate(java.lang.String, org.hibernate.EntityMode, java.io.Serializable)
	 */
	public Object instantiate(String arg0, EntityMode arg1, Serializable arg2)
			throws CallbackException {
		return null;
	}

	/**
	 * @see org.hibernate.Interceptor#getEntityName(java.lang.Object)
	 */
	public String getEntityName(Object arg0) throws CallbackException {
		return null;
	}

	/**
	 * @see org.hibernate.Interceptor#getEntity(java.lang.String, java.io.Serializable)
	 */
	public Object getEntity(String arg0, Serializable arg1)
			throws CallbackException {
		return null;
	}

	/**
	 * @see org.hibernate.Interceptor#afterTransactionBegin(org.hibernate.Transaction)
	 */
	public void afterTransactionBegin(Transaction arg0) {
	}

	/**
	 * @see org.hibernate.Interceptor#beforeTransactionCompletion(org.hibernate.Transaction)
	 */
	public void beforeTransactionCompletion(Transaction arg0) {
	}

	/**
	 * @see org.hibernate.Interceptor#afterTransactionCompletion(org.hibernate.Transaction)
	 */
	public void afterTransactionCompletion(Transaction arg0) {
	}

	/**
	 * @see org.hibernate.Interceptor#onPrepareStatement(java.lang.String)
	 */
	public String onPrepareStatement(String arg0) {
		return null;
	}
}