/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.persistent;

import java.io.Serializable;

/**
 * Initial javadoc for class QueryInfo.
 * 
 * Created Sep 18, 2006 10:33:23 PM
 * @author DNS   BOHMEG
 */
public class QueryInfo implements Serializable {
	/**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -438086212115304643L;
   public static final int DEFAULT_FETCH_SIZE = 100;
	private String query;
	private boolean isNamedQuery = true;
	private String[] paramNames;
	private Object[] paramValues;
	private int fetchSize = DEFAULT_FETCH_SIZE;

	public QueryInfo() { }
	
	public QueryInfo(String queryName) {
		this.query = queryName;
	}
	
	/**
	 * @return Returns the isNamedQuery.
	 */
	public boolean isNamedQuery() {
		return isNamedQuery;
	}
	/**
	 * @param isNamedQuery The isNamedQuery to set.
	 */
	public void setNamedQuery(boolean isNamedQuery) {
		this.isNamedQuery = isNamedQuery;
	}
	/**
	 * @return Returns the paramNames.
	 */
	public String[] getParamNames() {
		return paramNames;
	}
	/**
	 * @param paramNames The paramNames to set.
	 */
	public void setParamNames(String[] paramNames) {
		this.paramNames = paramNames;
	}
	/**
	 * @return Returns the paramValues.
	 */
	public Object[] getParamValues() {
		return paramValues;
	}
	/**
	 * @param paramValues The paramValues to set.
	 */
	public void setParamValues(Object[] paramValues) {
		this.paramValues = paramValues;
	}
	/**
	 * @return Returns the query.
	 */
	public String getQuery() {
		return query;
	}
	/**
	 * @param query The query to set.
	 */
	public void setQuery(String query) {
		this.query = query;
	}
	
    public boolean containsParameters() {
        return paramNames != null && paramNames.length > 0;
    }
	/**
	 * @return Returns the fetchSize.
	 */
	public int getFetchSize() {
		return fetchSize;
	}
	/**
	 * @param fetchSize The fetchSize to set.
	 */
	public void setFetchSize(int fetchSize) {
		this.fetchSize = fetchSize;
	}	
}
