/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model.lookup;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.enums.EnumUtils;

/**
 * Initial javadoc for class SimpleLookupUtils. TODO - Add content here
 * 
 * Created Aug 4, 2006 1:54:16 PM
 * 
 * @author DNS   BOHMEG
 */
public class SimpleLookupUtils {
	static Map classToConstants = new HashMap();

	public static Map getAllValues(Class clazz) {
		return EnumUtils.getEnumMap(clazz);
	}

	public static Lookup getByCode(Class clazz, String code) throws ClassNotFoundException {
		Class enumClazz = Class.forName(clazz.getName(), true, clazz.getClassLoader());
		return (Lookup) EnumUtils.getEnum(enumClazz, code);
	}

	// not public
	static void addLookupClass(Class clazz) {
		if (!classToConstants.containsKey(clazz))
			classToConstants.put(clazz, null);
	}

	static String getConstantName(Class clazz, String code) {
		return getEnumConstants(clazz).getConstantName(code);
	}
	
	private static synchronized EnumConstants getEnumConstants(Class clazz) {
		EnumConstants constants = (EnumConstants) classToConstants.get(clazz);
		if(constants == null) {
			constants = new EnumConstants(clazz);
			classToConstants.put(clazz, constants);
		}
		return constants;
	}
}
