/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model.lookup;

import java.util.Iterator;
import java.util.Map;

import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.enums.Enum;
import org.springframework.core.Constants;

/**
 * Lookup implementation for eumerated values that are not database driven.
 * 
 * Created Aug 3, 2006 4:19:58 PM
 * 
 * @author DNS   BOHMEG
 */
public abstract class AbstractSimpleLookup extends Enum implements Lookup {
	/**
	 * 
	 */
	private static final long serialVersionUID = -1063943405242112824L;

	public AbstractSimpleLookup(String code) {
		super(code);
		SimpleLookupUtils.addLookupClass(getClass());
	}
	
	public String getCode() {
		return getName();
	}
	
	public String getDescription() {
		return SimpleLookupUtils.getConstantName(getClass(), getCode());
	}
	
	public final String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append(ClassUtils.getShortClassName(getClass())).append(" [");
		buf.append(getCode()).append(", ");
		buf.append(getDescription()).append("]");
		return buf.toString();
	}
}

class EnumConstants extends Constants {
	EnumConstants(Class clazz) {
		super(clazz);		
	}
	
	String getConstantName(String code) {
		Map constantToLookup = getFieldCache();
		Iterator itr = constantToLookup.keySet().iterator();
		String constantName = null;
		Lookup lookup = null;
		while(itr.hasNext()) {
			constantName = (String) itr.next();
			lookup = (Lookup) constantToLookup.get(constantName);
			if(code.equals(lookup.getCode()))
				return constantName;					
		}
		return null;
	}
}

