/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.security.RolePrincipal;
import gov.va.med.fw.security.UserPrincipal;

/**
 * Implementation of RolePrincipal.
 * 
 * @author Ghazenfer Mansoor
 */
public class RolePrincipalImpl extends AbstractKeyedEntity implements
		RolePrincipal {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2691128619281850078L;

	private String name = null;

	private String description = null;

	private Set internalUsers = null;

	/**
	 * Default Constructor
	 */
	public RolePrincipalImpl() {
		super();
	}

	/**
	 * Construct using role name.
	 * 
	 * @param name
	 */
	public RolePrincipalImpl(String name) {
		super();
		this.name = name;
	}

	/**
	 * @see java.security.Principal#getName()
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * Set the Principal name
	 * 
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	private Set getInternalUsers() {
		if (internalUsers == null) {
			internalUsers = new HashSet();
		}
		return internalUsers;
	}

	private void setInternalUsers(Set internalUsers) {
		this.internalUsers = internalUsers;
	}

	/**
	 * @see gov.va.med.fw.security.RolePrincipal#getRoleUsers()
	 */
	public Set getRoleUsers() {
		return Collections.unmodifiableSet(getInternalUsers());
	}

	/**
	 * Helper method to add a given UserPrincipal to this role.
	 * 
	 * @param user -
	 *           a UserPrincipal
	 */
	public void addRoleUser(UserPrincipal userPrincipal) {
		Validate.notNull(userPrincipal, "Can not add null UserPrincipal");
		getInternalUsers().add(userPrincipal);
	}

	/**
	 * Helper method to remove UserPrincipal.
	 * 
	 * @param rolePrincipal
	 */
	public void removeRoleUser(UserPrincipal userPrincipal) {
		Validate.notNull(userPrincipal, "Can not remove null UserPrincipal");
		getInternalUsers().remove(userPrincipal);
	}

	/**
	 * @see com.vha.fw.model.AbstractEntity#buildToString()
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("name", this.name);
		builder.append("description", this.description);
	}

	public boolean equals(Object o) {
		return ((this == o) || (o instanceof RolePrincipal && this
				.equals((RolePrincipal) o)));
	}

	protected boolean equals(RolePrincipal rolePrincipal) {
		return (rolePrincipal != null && this.getName() != null
				&& rolePrincipal.getName() != null && this.getName().equals(
				rolePrincipal.getName()));
	}

	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();
		this.setInternalUsers(null);
	}
}