/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

// Package
package gov.va.med.fw.model;

// Java classes
import java.io.Serializable;
import java.math.BigDecimal;

import gov.va.med.fw.service.AbstractComponent;

/**
 * Factory for creating appropriate EntityKey implementations.
 * 
 * Created Jul 31, 2005 9:50:27 PM
 * 
 * @author DNS   BOHMEG
 */
public class EntityKeyFactory extends AbstractComponent {
	public static EntityKey createEntityKey(Serializable identifier, Class targetClass) {
		return new BaseEntityKey(identifier, targetClass);
	}
	
	public static EntityKey createEntityKey(Serializable identifier, Integer version, Class targetClass) {
		return new BaseEntityKey(identifier, version, targetClass);
	}

	public static EntityKey createEntityKey(String identifier, Class targetClass) {
		return new BaseEntityKey(new BigDecimal(identifier), targetClass);
	}	
}
