/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.mail;

// Java classes
import java.io.Serializable;

// Library classes
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.MailException;

// Framework classes

// ESR classes

/**
 * Provides generic methods to send simple text messages as well as MIME messages.  
 * Provides additional 2 most common methods to send a simple text message and a 
 * text message with an attachment file.   
 *
 * Project: Framework</br>
 * Created on: 10:41:17 AM </br>
 *
 * @author DNS   LEV
 */
public interface MailService extends JavaMailSender, Serializable {
	
	/** Sends a simple text message with a predefined e-mail template
	 * containing properties such as subject, from, to, etc ...
	 * 
	 * @param text A simple text message
	 * @param template An e-mail template 
	 * @throws MailException Thrown in case of errors in sending message 
	 */
	public void send( String text, SimpleMailMessage template ) throws MailException;
	
	/** Sends a simple text message, an atachment, and an e-mail template
	 * containing properties such as subject, from, to, etc...
	 * 
	 * @param text A simple text message
	 * @param attachment An attachment
	 * @param template An e-mail template
	 * @throws MailException Thrown in case of errors in sending message 
	 */
	public void send( String text, String attachment, SimpleMailMessage template ) throws MailException;

	/** Sends a simple text message, an atachment, and an e-mail template
	 * containing properties such as subject, from, to, etc...
	 * 
	 * @param text A simple text message
	 * @param resource An attachment
	 * @param template An e-mail template's stream
	 * @throws MailException Thrown in case of errors in sending message 
	 */
	public void send( String text, Resource resource, SimpleMailMessage template ) throws MailException;
	
	/** Sends a simple text message, an atachment, and an e-mail template
	 * containing properties such as subject, from, to, etc...
	 * 
	 * @param text A simple text message
	 * @param resource An attachment
	 * @param template An e-mail template's stream
	 * @param name An attachment file's name
	 * @throws MailException Thrown in case of errors in sending message 
	 */
	public void send( String text, Resource resource, SimpleMailMessage template, String name ) throws MailException;
}