/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.mail;

import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * Combo of Commons Lang multi-line and short-prefix
 * 
 * Created Feb 6, 2006 11:15:22 AM
 * 
 * @author DNS   BOHMEG
 */
public class FormattedObjectMailStyle extends ToStringStyle { 
	
	/**
	 * serialVersionUID long
	 */
	private static final long serialVersionUID = -5742147181077084985L;

	public FormattedObjectMailStyle() {
		super();
		this.setContentStart("[");
		this.setFieldSeparator(SystemUtils.LINE_SEPARATOR + "  ");
		this.setFieldSeparatorAtStart(true);
		this.setUseShortClassName(true);
		this.setUseIdentityHashCode(false);
		this.setContentEnd(SystemUtils.LINE_SEPARATOR + "]");
	}

	private Object readResolve() {
		return ToStringStyle.MULTI_LINE_STYLE;
	}
}
