/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.mail;

// Java classes
import java.io.InputStream;
import javax.mail.internet.MimeMessage;

// Library classes
import org.apache.commons.lang.Validate;
import org.springframework.core.io.Resource;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.MimeMessagePreparator;

// Framework classes
import gov.va.med.fw.service.AbstractComponent;

/**
 * Allow for injection of specific concrete mail service either synchronous or
 * asynchronous service.  This service is recommended to be used as a public 
 * interface to application services. </br> 
 *
 * Project: Framework</br>
 * Created on: 10:55:55 AM </br>
 *
 * @author DNS   LEV
 */
public class ConfigurableMailService extends AbstractComponent implements MailService {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8735063972257421990L;

	/**
	 * An instance of mailService
	 */
	private MailService mailService = null;
	
	/**
	 * A default constructor
	 */
	public ConfigurableMailService() {
		super();
	}

	/**
	 * @param mailService The mailService to set.
	 */
	public void setMailService(MailService mailService) {
		this.mailService = mailService;
	}

	/**
	 * @see gov.va.med.fw.service.AbstractComponent#afterPropertiesSet()
	 */
	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
		Validate.notNull( this.mailService, "A mail service must be configured" );
	}

	/**
	 * @see org.springframework.mail.javamail.JavaMailSender#createMimeMessage()
	 */
	public MimeMessage createMimeMessage() {
		return mailService.createMimeMessage();
	}

	/**
	 * @see org.springframework.mail.javamail.JavaMailSender#createMimeMessage(java.io.InputStream)
	 */
	public MimeMessage createMimeMessage(InputStream arg0) throws MailException {
		return mailService.createMimeMessage(arg0);
	}

	/**
	 * @see org.springframework.mail.javamail.JavaMailSender#send(javax.mail.internet.MimeMessage)
	 */
	public void send(MimeMessage arg0) throws MailException {
		mailService.send(arg0);
	}

	/**
	 * @see org.springframework.mail.javamail.JavaMailSender#send(javax.mail.internet.MimeMessage[])
	 */
	public void send(MimeMessage[] arg0) throws MailException {
		mailService.send(arg0);
	}

	/**
	 * @see org.springframework.mail.javamail.JavaMailSender#send(org.springframework.mail.javamail.MimeMessagePreparator)
	 */
	public void send(MimeMessagePreparator arg0) throws MailException {
		mailService.send(arg0);
	}

	/**
	 * @see org.springframework.mail.javamail.JavaMailSender#send(org.springframework.mail.javamail.MimeMessagePreparator[])
	 */
	public void send(MimeMessagePreparator[] arg0) throws MailException {
		mailService.send(arg0);
	}

	/**
	 * @see org.springframework.mail.MailSender#send(org.springframework.mail.SimpleMailMessage)
	 */
	public void send(SimpleMailMessage arg0) throws MailException {
		mailService.send(arg0);
	}

	/**
	 * @see org.springframework.mail.MailSender#send(org.springframework.mail.SimpleMailMessage[])
	 */
	public void send(SimpleMailMessage[] arg0) throws MailException {
		mailService.send(arg0);
	}

	/**
	 * @see gov.va.med.fw.mail.MailService#send(java.lang.String, org.springframework.core.io.Resource, org.springframework.mail.SimpleMailMessage)
	 */
	public void send(String text, Resource resource, SimpleMailMessage template) throws MailException {
		mailService.send(text, resource, template);
	}

	/**
	 * @see gov.va.med.fw.mail.MailService#send(java.lang.String, org.springframework.mail.SimpleMailMessage)
	 */
	public void send(String text, SimpleMailMessage template) throws MailException {
		mailService.send(text, template);
	}

	/**
	 * @see gov.va.med.fw.mail.MailService#send(java.lang.String, java.lang.String, org.springframework.mail.SimpleMailMessage)
	 */
	public void send(String text, String attachment, SimpleMailMessage template) throws MailException {
		mailService.send(text, attachment, template);
	}

	/**
	 * @see gov.va.med.fw.mail.MailService#send(java.lang.String, org.springframework.core.io.Resource, org.springframework.mail.SimpleMailMessage, java.lang.String)
	 */
	public void send(String text, Resource resource, SimpleMailMessage template, String contentType) throws MailException {
		mailService.send(text, resource, template, contentType);
	}
}