/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.io.writer;

import org.apache.commons.lang.StringUtils;

import gov.va.med.fw.io.FileFieldMetaData;
import gov.va.med.fw.util.InvalidConfigurationException;

/**
 * Specific information regarding a field for writing to a File.
 * 
 * Created Feb 21, 2006 4:34:03 PM
 * @author DNS   BOHMEG
 */
public class OutputFileFieldMetaData extends FileFieldMetaData {
	private static char DEFAULT_FILLER_VALUE = ' ';
	private boolean beginNewLine;	
	private String sectionHeader;
	private int fillerCount;
	private String fillerValue;

	public Object transform(Object rawValue) {
		Object transformedValue = super.transform(rawValue);
		if(getMaxLength() > 0 && transformedValue != null) {
			// if setting the maxLength, then assume the transformed value should be a string
			String value = transformedValue.toString();
			if(StringUtils.isNotBlank(value)) {
				if(getMaxLength() < 4)
					transformedValue = value.substring(0, getMaxLength());
				else
					transformedValue = StringUtils.abbreviate(value, getMaxLength());
			}
		}
		return transformedValue;
	}
	
	/**
	 * @return Returns the sectionHeader.
	 */
	public String getSectionHeader() {
		return sectionHeader;
	}


	/**
	 * @param sectionHeader The sectionHeader to set.
	 */
	public void setSectionHeader(String sectionHeader) {
		this.sectionHeader = sectionHeader;
	}

	public boolean isSectionHeaderField() {
		return sectionHeader != null;
	}

	/**
	 * @return Returns the beginNewLine.
	 */
	public boolean isBeginNewLine() {
		return beginNewLine;
	}


	/**
	 * @param beginNewLine The beginNewLine to set.
	 */
	public void setBeginNewLine(boolean beginNewLine) {
		this.beginNewLine = beginNewLine;
	}


	/**
	 * @return Returns the fillerCount.
	 */
	public int getFillerCount() {
		return fillerCount;
	}


	/**
	 * @param fillerCount The fillerCount to set.
	 */
	public void setFillerCount(int fillerCount) {
		this.fillerCount = fillerCount;
	}
	
	public boolean isFillerField() {
		return fillerCount != 0;
	}
	
	public String getFillerValue() {
		return fillerValue;
	}
		
	public void afterPropertiesSet() {
		verifySettings();
		if(fillerCount < 0)
			throw new InvalidConfigurationException("fillerCount must be positive number");
		
		if(!isFixedWidthFormat() && getName() == null && !isSectionHeaderField() && fillerCount == 0)
			throw new InvalidConfigurationException("Name is required");
		else if(isFixedWidthFormat()) {
			if(getName() == null && fillerCount == 0) {
				// allow this but calculate the fillerCount from startPosition and endPosition
				fillerCount = getEndPosition() - getStartPosition() + 1;					
			}			
		}		
		
		if(fillerCount != 0 && getName() != null)
			throw new InvalidConfigurationException("Can not have filler count when there is a property name");
		
		if(fillerCount > 0) {
			StringBuffer buf = new StringBuffer(fillerCount);
			for(int i=0 ; i<fillerCount; i++)
				buf.append(DEFAULT_FILLER_VALUE);
			fillerValue = buf.toString();
		}
	}
}
