/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.io.parser;

import java.util.List;

import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;

/**
 * Interface for those services that process data from a file and would like to be
 * notified after n number of objects created.  Allows to process data in chunks,
 * or even one at a time - rather than waiting for all the data to be built.
 * 
 * Created Feb 2, 2006 4:04:45 PM
 * @author DNS   BOHMEG
 */
public interface FileParserListener  {
	public boolean acceptData(DataFileProcessExecutionContext context, String nextRowRawData, List beans);
	
	public void processData(DataFileProcessExecutionContext context, List acquiredData) throws Exception;
	
	/**
	 * 
	 * @param context
	 * @param e
	 * @return Indicates to caller if they should keep any accumulated data
	 */
	public boolean beanCreationFailure(DataFileProcessExecutionContext context, String nextRowRawData, Exception e);
	public void beanCreationSuccess(DataFileProcessExecutionContext context, String nextRowRawData);
	public boolean isInterrupted(DataFileProcessExecutionContext context);
}
