/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.io;

import com.infomata.data.DataRow;

import gov.va.med.fw.io.parser.InputDataFormat;


/**
 * Specialization that captures the "raw data".  Note this is not thread-safe and must be synchronized
 * externally.
 * 
 * Created Feb 16, 2006 1:24:37 PM
 * @author DNS   BOHMEG
 */
public class SimpleDelimiterFormat extends
		com.infomata.data.SimpleDelimiterFormat implements InputDataFormat,
		DelimitedFormat {
	private String inputRawData;
	private String delimiter;
	
	public SimpleDelimiterFormat(String delimiter, String escape) {
		super(delimiter, escape);
		this.delimiter = delimiter;
	}
	
	public SimpleDelimiterFormat(String delimiter) {
		super(delimiter, null);
		this.delimiter = delimiter;
	}

	public DataRow parseLine(String rawData) {
		this.inputRawData = rawData.trim();		
		return inputRawData.length() != 0 ? super.parseLine(rawData) : new DataRow();
	}

	/**
	 * @return Returns the inputRawData.
	 */
	public String getInputRawData() {
		return inputRawData;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.DelimitedFormat#getDelimiter()
	 */
	public String getDelimiter() {
		return delimiter;
	}
}
