package gov.va.med.fw.io;

import org.apache.commons.collections.OrderedMap;

import com.infomata.data.DataRow;


/**
 * RawFileRowData is the default implementation to store the raw and parsed file data.
 * 
 * Created Apr 19, 2006 10:56:11 AM
 * @author DNS   MANSOG
 */
public class RawFileRowData implements RawFileDataContainer {
    private DataRow parsedRow = null;
    private String rawRow = null;
    private ClassMapping classMapping = null;

    /**
     * @see gov.va.med.fw.io.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow, gov.va.med.fw.io.ClassMapping)
     */
    public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
        this.rawRow = rawFileData;
        this.parsedRow = parsedRow;
        this.classMapping = classMapping;
    }

    /**
     * This method returns null, use getParsedRow() to get the row data.
     * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
     */
    public OrderedMap getRawFileData() throws Exception {
        return null;
    }

    /**
     * Return the parsed row as a DataRow.
     * @return DataRow
     */
    public DataRow getParsedRow() {
        return parsedRow;
    }
    
    /**
     * @return Returns the classMapping.
     */
    public ClassMapping getClassMapping() {
        return classMapping;
    }
    
    /**
     * @return Returns the raw row data.
     */
    public String getRawRow() {
        return rawRow;
    }

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getClassesForAutoRegisterConverters()
	 */
	public Class[] getClassesForAutoRegisterConverters() {
		// TODO Auto-generated method stub
		return null;
	}
}
