/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;

import com.infomata.data.DataRow;

/**
 * List decoration as an instance of RawFileDataContainer.
 * 
 * Created Apr 12, 2006 10:31:49 AM
 * @author DNS   BOHMEG
 */
public class RawFileDataList extends ArrayList implements RawFileDataContainer {
	
	/**
	 * serialVersionUID long
	 */
	private static final long serialVersionUID = 5318465818344491125L;
	private Map nameToObject = new HashMap();

	/** (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow, gov.va.med.fw.io.ClassMapping)
	 */
	public void setRawFileData(String rawFileData, DataRow parsedRow,
			ClassMapping classMapping) throws Exception {
		Iterator itr = parsedRow.iterator();
		while(itr.hasNext())
			add(itr.next());
	}

	/** (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
	 */
	public OrderedMap getRawFileData() throws Exception {
		OrderedMap map = new ListOrderedMap();
		Object obj = null;
		for(int i=0; i < size(); i++) {
			obj = get(i);
			if(nameToObject.containsKey(obj))
				map.put(obj, nameToObject.get(obj));
			else 
				map.put(""+(i + 1), obj);
		}
		return map;
	}
	
	public boolean addValueToBeTransformed(String name, Object value) {
		nameToObject.put(name, value);
		return add(name);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getClassesForAutoRegisterConverters()
	 */
	public Class[] getClassesForAutoRegisterConverters() {
		// TODO Auto-generated method stub
		return null;
	}
}
