package gov.va.med.fw.io;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.builder.Builder;

/**
 * Transforms data based on a configuration mapping.
 * The data passed in is the key based on which the value is
 * looked up in the configuration map.
 * 
 * @author Rajiv Patnaik
 * Created on Mar 31, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class MappedDataTransformer extends AbstractComponent implements FieldTransformer
{
    Builder mappedDataBuilder;

    /* (non-Javadoc)
     * @see gov.va.med.fw.io.FieldTransformer#transformData(java.lang.String, java.lang.Object)
     */
    public Object transformData(String fieldName, Object data) throws Exception
    {
        if(data == null)
            return null;
        
        return mappedDataBuilder.build(data);
    }
    
    /**
     * @return Returns the mappedDataBuilder.
     */
    public Builder getMappedDataBuilder()
    {
        return mappedDataBuilder;
    }
    /**
     * @param mappedDataBuilder The mappedDataBuilder to set.
     */
    public void setMappedDataBuilder(Builder mappedDataBuilder)
    {
        this.mappedDataBuilder = mappedDataBuilder;
    }
}
