/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.io;

import com.infomata.data.DataRow;

import gov.va.med.fw.io.parser.InputDataFormat;

/**
 * Specialization that captures the "raw data".  Note this is not thread-safe and must be synchronized
 * externally.
 * 
 * Created Feb 16, 2006 1:23:05 PM
 * 
 * @author DNS   BOHMEG
 */
public class FixedWidthFormat extends com.infomata.data.FixedWidthFormat
		implements InputDataFormat {
	private String inputRawData;

	public FixedWidthFormat(int[] widths) {
		super(widths);
	}

	public DataRow parseLine(String rawData) {
		this.inputRawData = rawData.trim();		
		return inputRawData.length() != 0 ? super.parseLine(rawData) : new DataRow();
	}

	/**
	 * @return Returns the inputRawData.
	 */
	public String getInputRawData() {
		return inputRawData;
	}
}
