/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.io;

import com.infomata.data.DataRow;

import gov.va.med.fw.io.parser.InputDataFormat;

/**
 * Specialization that captures the "raw data".  Note this is not thread-safe and must be synchronized
 * externally.
 * 
 * Created Feb 16, 2006 1:03:40 PM
 * 
 * @author DNS   BOHMEG
 */
public class CSVFormat extends com.infomata.data.CSVFormat implements InputDataFormat,
	DelimitedFormat {
	private static String DELIMITER = ",";
	private String inputRawData;
	
	public DataRow parseLine(String rawData) {
		this.inputRawData = rawData.trim();		
		return inputRawData.length() != 0 ? super.parseLine(rawData) : new DataRow();
	}

	/**
	 * @return Returns the inputRawData.
	 */
	public String getInputRawData() {
		return inputRawData;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.DelimitedFormat#getDelimiter()
	 */
	public String getDelimiter() {
		return DELIMITER;
	}
}
