/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

// Framework classes
import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZIV segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZIV extends Segment {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8499899330024508038L;

	/**
     * Constructs an empty segment. This constructor is ususally usd by derived
     * segment classes to populate its own segment data.
     */
    public ZIV() {
        super();
        setName(SegmentConstants.ZIV);
    }

    /**
     * Constructs a segment of elements from a raw data string. This constructor
     * is usually used to construct an inbound message from a raw message's
     * segment data.
     * 
     * @param data
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public ZIV(String data) throws InvalidSegmentException {
        super(data);
    }

    /**
     * Constructs a segment of elements from a raw data string, an array of
     * valid encoding character strings, and a element delimiter string. This
     * constructor is usually used to construct an inbound message from a raw
     * message's segment data, a specific encoding characters, and a field
     * delimiter.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentData
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public ZIV(String[] encodingChars, String elementDelimiter,
            String segmentData) throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentData);
    }

    /**
     * Constructs a segment from a segment name and a list of elements. This
     * constructor is usually used to construct an outbound message from a list
     * of specific segment elements, and a segment name.
     * 
     * @param name
     *            A segment name
     * @param elements
     *            A list of segment elements
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public ZIV(String name, List elements) throws InvalidSegmentException {
        super(name, elements);
    }

    /**
     * Constructs a segment from an array of encoding characters, a field
     * delimiter, a segment name, and a list of field data. This constructor is
     * usually used to construct an outbound message from a list of specific
     * segment elements, element delimiter, and encoding characters.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentName
     *            A segment name
     * @param segmentElements
     *            A list of field data
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public ZIV(String[] encodingChars, String elementDelimiter,
            String segmentName, List segmentElements)
            throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentName, segmentElements);
    }

    /**
     * 
     * Sequential Number
     * 
     * @param input
     *            A value of SetID
     */
    public void setSetID(String input) {
        setElement(input, 0);
    }

    /**
     * 
     * Sequential Number
     * 
     * @return String A value of SetID
     */
    public String getSetID() {
        return getElement(0);
    }

    /**
     * 
     * (Imprecise)
     * 
     * @param input
     *            A value of IncomeYear
     */
    public void setIncomeYear(String input) {
        setElement(input, 1);
    }

    /**
     * 
     * (Imprecise)
     * 
     * @return String A value of IncomeYear
     */
    public String getIncomeYear() {
        return getElement(1);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of ClientIDErrorMessage
     */
    public void setClientIDErrorMessage(String input) {
        setElement(input, 2);
    }

    /**
     * 
     * 
     * 
     * @return String A value of ClientIDErrorMessage
     */
    public String getClientIDErrorMessage() {
        return getElement(2);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of NewClientSSN
     */
    public void setNewClientSSN(String input) {
        setElement(input, 3);
    }

    /**
     * 
     * 
     * 
     * @return String A value of NewClientSSN
     */
    public String getNewClientSSN() {
        return getElement(3);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of SpouseIDErrorMessage
     */
    public void setSpouseIDErrorMessage(String input) {
        setElement(input, 4);
    }

    /**
     * 
     * 
     * 
     * @return String A value of SpouseIDErrorMessage
     */
    public String getSpouseIDErrorMessage() {
        return getElement(4);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of NewSpouseSSN
     */
    public void setNewSpouseSSN(String input) {
        setElement(input, 5);
    }

    /**
     * 
     * 
     * 
     * @return String A value of NewSpouseSSN
     */
    public String getNewSpouseSSN() {
        return getElement(5);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of SpouseID
     */
    public void setSpouseID(String input) {
        setElement(input, 6);
    }

    /**
     * 
     * 
     * 
     * @return String A value of SpouseID
     */
    public String getSpouseID() {
        return getElement(6);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of IvmCareStatus
     */
    public void setIvmCareStatus(String input) {
        setElement(input, 7);
    }

    /**
     * 
     * 
     * 
     * @return String A value of IvmCareStatus
     */
    public String getIvmCareStatus() {
        return getElement(7);
    }

    /**
     * 
     * REASON NOT UPLOADING INSURANCE (.08) 1 - ALREADY HAVE INSURANCE POLICY 2 -
     * DATA APPEARS TO BE INCORRECT 3 - NSURANCE COMPANY CLOSED 4 - POLICY PLAN
     * TYPE IS HMO 5 - POLICY PLAN TYPE IS PPO 6 - POLICY COVERAGE EXPIRED 7 -
     * POLICY BENEFITS FULLY USED 8 - BENEFITS NOT AVAILABLE 9 - COVERAGE FOR
     * SPOUSE ONLY
     * 
     * @param input
     *            A value of IvmID
     */
    public void setIvmID(String input) {
        setElement(input, 8);
    }

    /**
     * 
     * REASON NOT UPLOADING INSURANCE (.08) 1 - ALREADY HAVE INSURANCE POLICY 2 -
     * DATA APPEARS TO BE INCORRECT 3 - NSURANCE COMPANY CLOSED 4 - POLICY PLAN
     * TYPE IS HMO 5 - POLICY PLAN TYPE IS PPO 6 - POLICY COVERAGE EXPIRED 7 -
     * POLICY BENEFITS FULLY USED 8 - BENEFITS NOT AVAILABLE 9 - COVERAGE FOR
     * SPOUSE ONLY
     * 
     * @return String A value of IvmID
     */
    public String getIvmID() {
        return getElement(8);
    }

    /**
     * 
     * UPLOAD INSURANCE DATA (.04) 0 - NOT UPLOADED 1 - UPLOADED
     * 
     * @param input
     *            A value of InsuranceUploadStatus
     */
    public void setInsuranceUploadStatus(String input) {
        setElement(input, 9);
    }

    /**
     * 
     * UPLOAD INSURANCE DATA (.04) 0 - NOT UPLOADED 1 - UPLOADED
     * 
     * @return String A value of InsuranceUploadStatus
     */
    public String getInsuranceUploadStatus() {
        return getElement(9);
    }

    /**
     * 
     * IVM SPECIFIC INTERNAL ENTRY ID (.07)
     * 
     * @param input
     *            A value of ReasonInsuranceNotUploaded
     */
    public void setReasonInsuranceNotUploaded(String input) {
        setElement(input, 10);
    }

    /**
     * 
     * IVM SPECIFIC INTERNAL ENTRY ID (.07)
     * 
     * @return String A value of ReasonInsuranceNotUploaded
     */
    public String getReasonInsuranceNotUploaded() {
        return getElement(10);
    }

    /**
     * 
     * DATE OF DEATH (.351) Patient (#2) file. (Imprecise)
     * 
     * @param input
     *            A value of ClientDeathDate
     */
    public void setClientDeathDate(String input) {
        setElement(input, 11);
    }

    /**
     * 
     * DATE OF DEATH (.351) Patient (#2) file. (Imprecise)
     * 
     * @return String A value of ClientDeathDate
     */
    public String getClientDeathDate() {
        return getElement(11);
    }
}