package gov.va.med.fw.hl7.segment;

import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

public class ZE2 extends Segment {
	

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6190146969093086878L;

	/**
     * Constructs an empty segment. This constructor is ususally usd by derived
     * segment classes to populate its own segment data.
     */
    public ZE2() {
        super();
        setName(SegmentConstants.ZE2);
    }

    /**
     * Constructs a segment of elements from a raw data string. This constructor
     * is usually used to construct an inbound message from a raw message's
     * segment data.
     * 
     * @param data
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public ZE2(String data) throws InvalidSegmentException {
        super(data);
    }

    /**
     * Constructs a segment of elements from a raw data string, an array of
     * valid encoding character strings, and a element delimiter string. This
     * constructor is usually used to construct an inbound message from a raw
     * message's segment data, a specific encoding characters, and a field
     * delimiter.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentData
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public ZE2(String[] encodingChars, String elementDelimiter,
            String segmentData) throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentData);
    }

    /**
     * Constructs a segment from a segment name and a list of elements. This
     * constructor is usually used to construct an outbound message from a list
     * of specific segment elements, and a segment name.
     * 
     * @param name
     *            A segment name
     * @param elements
     *            A list of segment elements
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public ZE2(String name, List elements) throws InvalidSegmentException {
        super(name, elements);
    }

    /**
     * Constructs a segment from an array of encoding characters, a field
     * delimiter, a segment name, and a list of field data. This constructor is
     * usually used to construct an outbound message from a list of specific
     * segment elements, element delimiter, and encoding characters.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentName
     *            A segment name
     * @param segmentElements
     *            A list of field data
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public ZE2(String[] encodingChars, String elementDelimiter,
            String segmentName, List segmentElements)
            throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentName, segmentElements);
    }
    

    /**
     * 
     * 
     * 
     * @param input
     *            A value of patientAwardEffectiveDate
     */
    public void setPensionDate(String input) {
        setElement(input, 0);
    }

    /**
     * 
     * Pension Award Effective Date
     * 
     * @return String A value of pensionAwardEffectiveDate
     */
    public String getPensionDate() {
        return getElement(0);
    }

    /**
     * 
     * Pension Award Reason Code
     * 
     * @param input
     *            A value of PensionAwardReasonCode
     */
    public void setPensionAwardReasonCode(String input) {
        setElement(input, 1);
    }

    /**
     * 
     * Pension Award Reason Code
     * 
     * @return String A value of PensionAwardReasonCode
     */
    public String getPensionAwardReasonCode() {    	
        return getElement(1);
    }    
    
    /**
     * 
     * Pension Award Terminated Reason
     * 
     * @param input
     *            A value of pensionAwardTerminatedReason
     */
    public void setPensionTerminatedReason(String input) {
        setElement(input, 2);
    }

    /**
     * Pension Award Terminated Reason
     * 
     * @return String A value of pensionAwardTerminatedReason
     */
    public String getPensionTerminatedReason() {
        return getElement(2);
    }

}
