/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

// Framework classes
import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A RF1 segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class RF1 extends Segment {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8072358439902418635L;

	/**
     * Constructs an empty segment. This constructor is ususally usd by derived
     * segment classes to populate its own segment data.
     */
    public RF1() {
        super();
        setName(SegmentConstants.RF1);
    }

    /**
     * Constructs a segment of elements from a raw data string. This constructor
     * is usually used to construct an inbound message from a raw message's
     * segment data.
     * 
     * @param data
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public RF1(String data) throws InvalidSegmentException {
        super(data);
    }

    /**
     * Constructs a segment of elements from a raw data string, an array of
     * valid encoding character strings, and a element delimiter string. This
     * constructor is usually used to construct an inbound message from a raw
     * message's segment data, a specific encoding characters, and a field
     * delimiter.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentData
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public RF1(String[] encodingChars, String elementDelimiter,
            String segmentData) throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentData);
    }

    /**
     * Constructs a segment from a segment name and a list of elements. This
     * constructor is usually used to construct an outbound message from a list
     * of specific segment elements, and a segment name.
     * 
     * @param name
     *            A segment name
     * @param elements
     *            A list of segment elements
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public RF1(String name, List elements) throws InvalidSegmentException {
        super(name, elements);
    }

    /**
     * Constructs a segment from an array of encoding characters, a field
     * delimiter, a segment name, and a list of field data. This constructor is
     * usually used to construct an outbound message from a list of specific
     * segment elements, element delimiter, and encoding characters.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentName
     *            A segment name
     * @param segmentElements
     *            A list of field data
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public RF1(String[] encodingChars, String elementDelimiter,
            String segmentName, List segmentElements)
            throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentName, segmentElements);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of ReferralStatus
     */
    public void setReferralStatus(String input) {
        setElement(input, 0);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of ReferralStatus
     */
    public String getReferralStatus() {
        return getElement(0);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of ReferralPriority
     */
    public void setReferralPriority(String input) {
        setElement(input, 1);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of ReferralPriority
     */
    public String getReferralPriority() {
        return getElement(1);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of ReferralType
     */
    public void setReferralType(String input) {
        setElement(input, 2);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of ReferralType
     */
    public String getReferralType() {
        return getElement(2);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of ReferralDisposition
     */
    public void setReferralDisposition(String input) {
        setElement(input, 3);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of ReferralDisposition
     */
    public String getReferralDisposition() {
        return getElement(3);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of ReferralCategory
     */
    public void setReferralCategory(String input) {
        setElement(input, 4);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of ReferralCategory
     */
    public String getReferralCategory() {
        return getElement(4);
    }

    /**
     * 
     * 4 COMPONENTS: 1  SITE OF CHANGE 2  SOURCE OF CHANGE 3  NOT USED 4 
     * NOT USED( VISTA Messaging HL7)
     * 
     * @param input
     *            A value of OriginalReferralID
     */
    public void setOriginalReferralID(String input) {
        setElement(input, 5);
    }

    /**
     * 
     * 4 COMPONENTS: 1  SITE OF CHANGE 2  SOURCE OF CHANGE 3  NOT USED 4 
     * NOT USED( VISTA Messaging HL7)
     * 
     * @return String A value of OriginalReferralID
     */
    public String getOriginalReferralID() {
        return getElement(5);
    }

    /**
     * 
     * DATE/TIME OF CHANGE (Imprecise or ~ )
     * 
     * @param input
     *            A value of EffectiveDate
     */
    public void setEffectiveDate(String input) {
        setElement(input, 6);
    }

    /**
     * 
     * DATE/TIME OF CHANGE (Imprecise or ~ )
     * 
     * @return String A value of EffectiveDate
     */
    public String getEffectiveDate() {
        return getElement(6);
    }

    /**
     * 
     * INVALID ADDRESS DATE (Imprecise) (TBD)
     * 
     * @param input
     *            A value of ExpirationDate
     */
    public void setExpirationDate(String input) {
        setElement(input, 7);
    }

    /**
     * 
     * INVALID ADDRESS DATE (Imprecise) (TBD)
     * 
     * @return String A value of ExpirationDate
     */
    public String getExpirationDate() {
        return getElement(7);
    }

    /**
     * 
     * DATE CHECKED BY NCOA (Imprecise) (TBD)
     * 
     * @param input
     *            A value of ProcessDate
     */
    public void setProcessDate(String input) {
        setElement(input, 8);
    }

    /**
     * 
     * DATE CHECKED BY NCOA (Imprecise) (TBD)
     * 
     * @return String A value of ProcessDate
     */
    public String getProcessDate() {
        return getElement(8);
    }

    /**
     * 
     * INVALID ADDRESS REASON (TBD)
     * 
     * @param input
     *            A value of ReferralReason
     */
    public void setReferralReason(String input) {
        setElement(input, 9);
    }

    /**
     * 
     * INVALID ADDRESS REASON (TBD)
     * 
     * @return String A value of ReferralReason
     */
    public String getReferralReason() {
        return getElement(9);
    }
}