/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

// Framework classes
import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A QRD segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class QRD extends Segment {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3228017663441661599L;

	/**
     * Constructs an empty segment. This constructor is ususally usd by derived
     * segment classes to populate its own segment data.
     */
    public QRD() {
        super();
        setName(SegmentConstants.QRD);
    }

    /**
     * Constructs a segment of elements from a raw data string. This constructor
     * is usually used to construct an inbound message from a raw message's
     * segment data.
     * 
     * @param data
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public QRD(String data) throws InvalidSegmentException {
        super(data);
    }

    /**
     * Constructs a segment of elements from a raw data string, an array of
     * valid encoding character strings, and a element delimiter string. This
     * constructor is usually used to construct an inbound message from a raw
     * message's segment data, a specific encoding characters, and a field
     * delimiter.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentData
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public QRD(String[] encodingChars, String elementDelimiter,
            String segmentData) throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentData);
    }

    /**
     * Constructs a segment from a segment name and a list of elements. This
     * constructor is usually used to construct an outbound message from a list
     * of specific segment elements, and a segment name.
     * 
     * @param name
     *            A segment name
     * @param elements
     *            A list of segment elements
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public QRD(String name, List elements) throws InvalidSegmentException {
        super(name, elements);
    }

    /**
     * Constructs a segment from an array of encoding characters, a field
     * delimiter, a segment name, and a list of field data. This constructor is
     * usually used to construct an outbound message from a list of specific
     * segment elements, element delimiter, and encoding characters.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentName
     *            A segment name
     * @param segmentElements
     *            A list of field data
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public QRD(String[] encodingChars, String elementDelimiter,
            String segmentName, List segmentElements)
            throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentName, segmentElements);
    }

    /**
     * 
     * DATE/TIME QUERY WAS GENERATED (Precise Date)
     * 
     * @param input
     *            A value of QueryDate
     */
    public void setQueryDate(String input) {
        setElement(input, 0);
    }

    /**
     * 
     * DATE/TIME QUERY WAS GENERATED (Precise Date)
     * 
     * @return String A value of QueryDate
     */
    public String getQueryDate() {
        return getElement(0);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of QueryFormatCode
     */
    public void setQueryFormatCode(String input) {
        setElement(input, 1);
    }

    /**
     * 
     * 
     * 
     * @return String A value of QueryFormatCode
     */
    public String getQueryFormatCode() {
        return getElement(1);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of QueryPriority
     */
    public void setQueryPriority(String input) {
        setElement(input, 2);
    }

    /**
     * 
     * 
     * 
     * @return String A value of QueryPriority
     */
    public String getQueryPriority() {
        return getElement(2);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of QueryID
     */
    public void setQueryID(String input) {
        setElement(input, 3);
    }

    /**
     * 
     * 
     * 
     * @return String A value of QueryID
     */
    public String getQueryID() {
        return getElement(3);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of DeferredResponseType
     */
    public void setDeferredResponseType(String input) {
        setElement(input, 4);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of DeferredResponseType
     */
    public String getDeferredResponseType() {
        return getElement(4);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of DeferredResponseDate
     */
    public void setDeferredResponseDate(String input) {
        setElement(input, 5);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of DeferredResponseDate
     */
    public String getDeferredResponseDate() {
        return getElement(5);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of QuantityLimitedRequest
     */
    public void setQuantityLimitedRequest(String input) {
        setElement(input, 6);
    }

    /**
     * 
     * 
     * 
     * @return String A value of QuantityLimitedRequest
     */
    public String getQuantityLimitedRequest() {
        return getElement(6);
    }

    /**
     * 
     * 2 COMPONENTS 1.SOCIAL SECURITY NUMBER (.09) 2.INTEGERATED CONTROL # (ICN)
     * (991.01)  3 Sub-Components a.ICN b.CIRN c.Locally Assigned Flag (VISTA
     * Messaging HL7)
     * 
     * @param input
     *            A value of WhoSubjectFilter
     */
    public void setWhoSubjectFilter(String input) {
        setElement(input, 7);
    }

    /**
     * 
     * 2 COMPONENTS 1.SOCIAL SECURITY NUMBER (.09) 2.INTEGERATED CONTROL # (ICN)
     * (991.01)  3 Sub-Components a.ICN b.CIRN c.Locally Assigned Flag (VISTA
     * Messaging HL7)
     * 
     * @return String A value of WhoSubjectFilter
     */
    public String getWhoSubjectFilter() {
        return getElement(7);
    }

    /**
     * 
     * (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of WhatSubjectFilter
     */
    public void setWhatSubjectFilter(String input) {
        setElement(input, 8);
    }

    /**
     * 
     * (VISTA Messaging HL7)
     * 
     * @return String A value of WhatSubjectFilter
     */
    public String getWhatSubjectFilter() {
        return getElement(8);
    }

    /**
     * 
     * COMPUTED FIELD (INCOME YEAR) (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of WhatDepartmentDataCode
     */
    public void setWhatDepartmentDataCode(String input) {
        setElement(input, 9);
    }

    /**
     * 
     * COMPUTED FIELD (INCOME YEAR) (VISTA Messaging HL7)
     * 
     * @return String A value of WhatDepartmentDataCode
     */
    public String getWhatDepartmentDataCode() {
        return getElement(9);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of WhatDataCodeValue
     */
    public void setWhatDataCodeValue(String input) {
        setElement(input, 10);
    }

    /**
     * 
     * 
     * 
     * @return String A value of WhatDataCodeValue
     */
    public String getWhatDataCodeValue() {
        return getElement(10);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of QueryResultLevel
     */
    public void setQueryResultLevel(String input) {
        setElement(input, 11);
    }

    /**
     * 
     * 
     * 
     * @return String A value of QueryResultLevel
     */
    public String getQueryResultLevel() {
        return getElement(11);
    }
}