package gov.va.med.fw.hl7.segment;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

import java.util.List;

public class QPD extends Segment{
    


    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = 3228017663441661599L;

    /**
     * Constructs an empty segment. This constructor is ususally usd by derived
     * segment classes to populate its own segment data.
     */
    public QPD() {
        super();
        setName(SegmentConstants.QPD);
    }

    /**
     * Constructs a segment of elements from a raw data string. This constructor
     * is usually used to construct an inbound message from a raw message's
     * segment data.
     * 
     * @param data
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public QPD(String data) throws InvalidSegmentException {
        super(data);
    }

    /**
     * Constructs a segment of elements from a raw data string, an array of
     * valid encoding character strings, and a element delimiter string. This
     * constructor is usually used to construct an inbound message from a raw
     * message's segment data, a specific encoding characters, and a field
     * delimiter.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentData
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public QPD(String[] encodingChars, String elementDelimiter,
            String segmentData) throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentData);
    }

    /**
     * Constructs a segment from a segment name and a list of elements. This
     * constructor is usually used to construct an outbound message from a list
     * of specific segment elements, and a segment name.
     * 
     * @param name
     *            A segment name
     * @param elements
     *            A list of segment elements
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public QPD(String name, List elements) throws InvalidSegmentException {
        super(name, elements);
    }

    /**
     * Constructs a segment from an array of encoding characters, a field
     * delimiter, a segment name, and a list of field data. This constructor is
     * usually used to construct an outbound message from a list of specific
     * segment elements, element delimiter, and encoding characters.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentName
     *            A segment name
     * @param segmentElements
     *            A list of field data
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public QPD(String[] encodingChars, String elementDelimiter,
            String segmentName, List segmentElements)
            throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentName, segmentElements);
    }

    /**
     * 
     * QPDID
     * 
     * @param input
     *            A value of setID
     */
    /*public void setId(String input) {
        setElement(input, 0);
    }*/

    /**
     * 
     * QPDID
     * 
     * @return String A value of setID
     */
    /*public String getId() {
        return getElement(0);
    }*/

    /**
     * 
     * 
     * 
     * @param input
     *            A value of eventType
     */
    public void setEventType(String input) {
        setElement(input, 0);
    }

    /**
     * 
     * 
     * 
     * @return String A value of eventType
     */
    public String getEventType() {
        return getElement(0);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of comment
     */
    public void setComment(String input) {
        setElement(input, 1);
    }

    /**
     * 
     * 
     * 
     * @return String A value of comment
     */
    public String getComment() {
        return getElement(1);
    }

    /**
     * 
     * 
     * 
     * @param input
     *            A value of ICN
     */
    public void setICN(String input) {
        setElement(input, 2);
    }

    /**
     * 
     * 
     * 
     * @return String A value of ICN
     */
    public String getICN() {
        return getElement(2);
    }

    /**
     * 
     *  
     * @param input
     *            A value of DFN
     */
    public void setDFN(String input) {
        setElement(input, 3);
    }

    /**
     * 
     * 
     * @return String A value of DFN
     */
    public String getDFN() {
        return getElement(3);
    }

    

    


}
