/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

// Framework classes
import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A MFA segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class MFA extends Segment {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7754217002829268109L;

	/**
     * Constructs an empty segment. This constructor is ususally usd by derived
     * segment classes to populate its own segment data.
     */
    public MFA() {
        super();
        setName(SegmentConstants.MFA);
    }

    /**
     * Constructs a segment of elements from a raw data string. This constructor
     * is usually used to construct an inbound message from a raw message's
     * segment data.
     * 
     * @param data
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public MFA(String data) throws InvalidSegmentException {
        super(data);
    }

    /**
     * Constructs a segment of elements from a raw data string, an array of
     * valid encoding character strings, and a element delimiter string. This
     * constructor is usually used to construct an inbound message from a raw
     * message's segment data, a specific encoding characters, and a field
     * delimiter.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentData
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public MFA(String[] encodingChars, String elementDelimiter,
            String segmentData) throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentData);
    }

    /**
     * Constructs a segment from a segment name and a list of elements. This
     * constructor is usually used to construct an outbound message from a list
     * of specific segment elements, and a segment name.
     * 
     * @param name
     *            A segment name
     * @param elements
     *            A list of segment elements
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public MFA(String name, List elements) throws InvalidSegmentException {
        super(name, elements);
    }

    /**
     * Constructs a segment from an array of encoding characters, a field
     * delimiter, a segment name, and a list of field data. This constructor is
     * usually used to construct an outbound message from a list of specific
     * segment elements, element delimiter, and encoding characters.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentName
     *            A segment name
     * @param segmentElements
     *            A list of field data
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public MFA(String[] encodingChars, String elementDelimiter,
            String segmentName, List segmentElements)
            throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentName, segmentElements);
    }

    /**
     * 
     * SAME AS SENT BY VISTA
     * 
     * @param input
     *            A value of EventCode
     */
    public void setEventCode(String input) {
        setElement(input, 0);
    }

    /**
     * 
     * SAME AS SENT BY VISTA
     * 
     * @return String A value of EventCode
     */
    public String getEventCode() {
        return getElement(0);
    }

    /**
     * 
     * IEN OF THE ENTRY IN THE ENROLLMENT GROUP THRESHOLD FILE
     * 
     * @param input
     *            A value of ControlID
     */
    public void setControlID(String input) {
        setElement(input, 1);
    }

    /**
     * 
     * IEN OF THE ENTRY IN THE ENROLLMENT GROUP THRESHOLD FILE
     * 
     * @return String A value of ControlID
     */
    public String getControlID() {
        return getElement(1);
    }

    /**
     * 
     * DATE/TIME THE CHANGE TO THE MASTER FILE OCCURRED
     * 
     * @param input
     *            A value of EventCompletionDatetime
     */
    public void setEventCompletionDate(String input) {
        setElement(input, 2);
    }

    /**
     * 
     * DATE/TIME THE CHANGE TO THE MASTER FILE OCCURRED
     * 
     * @return String A value of EventCompletionDatetime
     */
    public String getEventCompletionDate() {
        return getElement(2);
    }

    /**
     * 
     * INDICATOR IF UPDATE SUCCESSFUL OR UNSUCCESSFUL
     * 
     * @param input
     *            A value of EventReturnCodeText
     */
    public void setEventReturnCodeText(String input) {
        setElement(input, 3);
    }

    /**
     * 
     * INDICATOR IF UPDATE SUCCESSFUL OR UNSUCCESSFUL
     * 
     * @return String A value of EventReturnCodeText
     */
    public String getEventReturnCodeText() {
        return getElement(3);
    }

    /**
     * 
     * SAME AS SENT IN THE MFE, SEQUENCE 4
     * 
     * @param input
     *            A value of PrimaryKeyValue
     */
    public void setPrimaryKeyValue(String input) {
        setElement(input, 4);
    }

    /**
     * 
     * SAME AS SENT IN THE MFE, SEQUENCE 4
     * 
     * @return String A value of PrimaryKeyValue
     */
    public String getPrimaryKeyValue() {
        return getElement(4);
    }
}