/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

// Framework classes
import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A IN1 segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class IN1 extends Segment {

    public static final String MEDICARE_PART_B = "PART B";
    public static final String MEDICARE_PART_A = "PART A";
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7341599260933867220L;

	/**
     * Constructs an empty segment. This constructor is ususally usd by derived
     * segment classes to populate its own segment data.
     */
    public IN1() {
        super();
        setName(SegmentConstants.IN1);
    }

    /**
     * Constructs a segment of elements from a raw data string. This constructor
     * is usually used to construct an inbound message from a raw message's
     * segment data.
     * 
     * @param data
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public IN1(String data) throws InvalidSegmentException {
        super(data);
    }

    /**
     * Constructs a segment of elements from a raw data string, an array of
     * valid encoding character strings, and a element delimiter string. This
     * constructor is usually used to construct an inbound message from a raw
     * message's segment data, a specific encoding characters, and a field
     * delimiter.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentData
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public IN1(String[] encodingChars, String elementDelimiter,
            String segmentData) throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentData);
    }

    /**
     * Constructs a segment from a segment name and a list of elements. This
     * constructor is usually used to construct an outbound message from a list
     * of specific segment elements, and a segment name.
     * 
     * @param name
     *            A segment name
     * @param elements
     *            A list of segment elements
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public IN1(String name, List elements) throws InvalidSegmentException {
        super(name, elements);
    }

    /**
     * Constructs a segment from an array of encoding characters, a field
     * delimiter, a segment name, and a list of field data. This constructor is
     * usually used to construct an outbound message from a list of specific
     * segment elements, element delimiter, and encoding characters.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentName
     *            A segment name
     * @param segmentElements
     *            A list of field data
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public IN1(String[] encodingChars, String elementDelimiter,
            String segmentName, List segmentElements)
            throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentName, segmentElements);
    }

    /**
     * 
     * SEQUENTIAL NUMBER
     * 
     * @param input
     *            A value of SetID
     */
    public void setSetID(String input) {
        setElement(input, 0);
    }

    /**
     * 
     * SEQUENTIAL NUMBER
     * 
     * @return String A value of SetID
     */
    public String getSetID() {
        return getElement(0);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of InsurancePlanID
     */
    public void setInsurancePlanID(String input) {
        setElement(input, 1);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of InsurancePlanID
     */
    public String getInsurancePlanID() {
        return getElement(1);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of InsuranceCompanyID
     */
    public void setInsuranceCompanyID(String input) {
        setElement(input, 2);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of InsuranceCompanyID
     */
    public String getInsuranceCompanyID() {
        return getElement(2);
    }

    /**
     * 
     * NAME INSURANCE COMPANY (#36) (.01) (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of InsuranceCompanyName
     */
    public void setInsuranceCompanyName(String input) {
        setElement(input, 3);
    }

    /**
     * 
     * NAME INSURANCE COMPANY (#36) (.01) (VISTA Messaging HL7)
     * 
     * @return String A value of InsuranceCompanyName
     */
    public String getInsuranceCompanyName() {
        return getElement(3);
    }

    /**
     * 
     * ADDRESS INSURANCE COMPANY (#36) (.111-.116) (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of InsuranceCompanyAddress
     */
    public void setInsuranceCompanyAddress(String input) {
        setElement(input, 4);
    }

    /**
     * 
     * ADDRESS INSURANCE COMPANY (#36) (.111-.116) (VISTA Messaging HL7)
     * 
     * @return String A value of InsuranceCompanyAddress
     */
    public String getInsuranceCompanyAddress() {
        return getElement(4);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of InsuranceCompanyContactPerson
     */
    public void setInsuranceCompanyContactPerson(String input) {
        setElement(input, 5);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of InsuranceCompanyContactPerson
     */
    public String getInsuranceCompanyContactPerson() {
        return getElement(5);
    }

    /**
     * 
     * PHONE NUMBER INSURANCE COMPANY (#36) (.131) (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of InsuranceCompanyPhoneNumber
     */
    public void setInsuranceCompanyPhoneNumber(String input) {
        setElement(input, 6);
    }

    /**
     * 
     * PHONE NUMBER INSURANCE COMPANY (#36) (.131) (VISTA Messaging HL7)
     * 
     * @return String A value of InsuranceCompanyPhoneNumber
     */
    public String getInsuranceCompanyPhoneNumber() {
        return getElement(6);
    }

    /**
     * 
     * GROUP NUMBER FIELD (#355.3) (.04) (Requirement for outbound, you need to
     * have at least one of the following *)
     * 
     * @param input
     *            A value of GroupNumber
     */
    public void setGroupNumber(String input) {
        setElement(input, 7);
    }

    /**
     * 
     * GROUP NUMBER FIELD (#355.3) (.04) (Requirement for outbound, you need to
     * have at least one of the following *)
     * 
     * @return String A value of GroupNumber
     */
    public String getGroupNumber() {
        return getElement(7);
    }

    /**
     * 
     * GROUP NAME FIELD (#355.3) (.03) (Requirement for outbound, you need to
     * have at least one of the following *)
     * 
     * @param input
     *            A value of GroupName
     */
    public void setGroupName(String input) {
        setElement(input, 8);
    }

    /**
     * 
     * GROUP NAME FIELD (#355.3) (.03) (Requirement for outbound, you need to
     * have at least one of the following *)
     * 
     * @return String A value of GroupName
     */
    public String getGroupName() {
        return getElement(8);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of InsuredGroupEmpID
     */
    public void setInsuredGroupEmpID(String input) {
        setElement(input, 9);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of InsuredGroupEmpID
     */
    public String getInsuredGroupEmpID() {
        return getElement(9);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of InsuredGroupEmpName
     */
    public void setInsuredGroupEmpName(String input) {
        setElement(input, 10);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of InsuredGroupEmpName
     */
    public String getInsuredGroupEmpName() {
        return getElement(10);
    }

    /**
     * 
     * EFFECTIVE DATE OF POLICY (#2.312) (8) (Imprecise Date)
     * 
     * @param input
     *            A value of PlanEffectiveDate
     */
    public void setPlanEffectiveDate(String input) {
        setElement(input, 11);
    }

    /**
     * 
     * EFFECTIVE DATE OF POLICY (#2.312) (8) (Imprecise Date)
     * 
     * @return String A value of PlanEffectiveDate
     */
    public String getPlanEffectiveDate() {
        return getElement(11);
    }

    /**
     * 
     * INSURANCE EXPIRATION DATE (#2.312) (4) (Imprecise Date)
     * 
     * @param input
     *            A value of PlanExpirationDate
     */
    public void setPlanExpirationDate(String input) {
        setElement(input, 12);
    }

    /**
     * 
     * INSURANCE EXPIRATION DATE (#2.312) (4) (Imprecise Date)
     * 
     * @return String A value of PlanExpirationDate
     */
    public String getPlanExpirationDate() {
        return getElement(12);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of AuthorizationInformation
     */
    public void setAuthorizationInformation(String input) {
        setElement(input, 13);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of AuthorizationInformation
     */
    public String getAuthorizationInformation() {
        return getElement(13);
    }

    /**
     * 
     * TYPE OF PLAN FIELD (#355.3) (.09) (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of PlanType
     */
    public void setPlanType(String input) {
        setElement(input, 14);
    }

    /**
     * 
     * TYPE OF PLAN FIELD (#355.3) (.09) (VISTA Messaging HL7)
     * 
     * @return String A value of PlanType
     */
    public String getPlanType() {
        return getElement(14);
    }

    /**
     * 
     * NAME OF INSURED (#2.312) (17) (Requirement for outbound, you need to have
     * at least one of the following *) (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of InsuredName
     */
    public void setInsuredName(String input) {
        setElement(input, 15);
    }

    /**
     * 
     * NAME OF INSURED (#2.312) (17) (Requirement for outbound, you need to have
     * at least one of the following *) (VISTA Messaging HL7)
     * 
     * @return String A value of InsuredName
     */
    public String getInsuredName() {
        return getElement(15);
    }

    /**
     * 
     * WHOSE INSURANCE (#2.312) (6) (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of InsuredRelationToPatient
     */
    public void setInsuredRelationToPatient(String input) {
        setElement(input, 16);
    }

    /**
     * 
     * WHOSE INSURANCE (#2.312) (6) (VISTA Messaging HL7)
     * 
     * @return String A value of InsuredRelationToPatient
     */
    public String getInsuredRelationToPatient() {
        return getElement(16);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of InsuredBirthDate
     */
    public void setInsuredBirthDate(String input) {
        setElement(input, 17);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of InsuredBirthDate
     */
    public String getInsuredBirthDate() {
        return getElement(17);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of InsuredAddress
     */
    public void setInsuredAddress(String input) {
        setElement(input, 18);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of InsuredAddress
     */
    public String getInsuredAddress() {
        return getElement(18);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of AssignmentOfBenefits
     */
    public void setAssignmentOfBenefits(String input) {
        setElement(input, 19);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of AssignmentOfBenefits
     */
    public String getAssignmentOfBenefits() {
        return getElement(19);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of CoordinationOfBenefits
     */
    public void setCoordinationOfBenefits(String input) {
        setElement(input, 20);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of CoordinationOfBenefits
     */
    public String getCoordinationOfBenefits() {
        return getElement(20);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of CoordinationOfBenefitsPriority
     */
    public void setCoordinationOfBenefitsPriority(String input) {
        setElement(input, 21);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of CoordinationOfBenefitsPriority
     */
    public String getCoordinationOfBenefitsPriority() {
        return getElement(21);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of NoticeOfAdmissionCode
     */
    public void setNoticeOfAdmissionCode(String input) {
        setElement(input, 22);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of NoticeOfAdmissionCode
     */
    public String getNoticeOfAdmissionCode() {
        return getElement(22);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of NoticeOfAdmissionDate
     */
    public void setNoticeOfAdmissionDate(String input) {
        setElement(input, 23);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of NoticeOfAdmissionDate
     */
    public String getNoticeOfAdmissionDate() {
        return getElement(23);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of ReportOfEligibilityFlag
     */
    public void setReportOfEligibilityFlag(String input) {
        setElement(input, 24);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of ReportOfEligibilityFlag
     */
    public String getReportOfEligibilityFlag() {
        return getElement(24);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of ReportOfEligibilityDate
     */
    public void setReportOfEligibilityDate(String input) {
        setElement(input, 25);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of ReportOfEligibilityDate
     */
    public String getReportOfEligibilityDate() {
        return getElement(25);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of ReleaseOfInformationCode
     */
    public void setReleaseOfInformationCode(String input) {
        setElement(input, 26);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of ReleaseOfInformationCode
     */
    public String getReleaseOfInformationCode() {
        return getElement(26);
    }

    /**
     * 
     * IS PRE-CERT. REQ. FIELD (#355.3) (.06) (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of PreadmitCertification
     */
    public void setPreadmitCertification(String input) {
        setElement(input, 27);
    }

    /**
     * 
     * IS PRE-CERT. REQ. FIELD (#355.3) (.06) (VISTA Messaging HL7)
     * 
     * @return String A value of PreadmitCertification
     */
    public String getPreadmitCertification() {
        return getElement(27);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of VerificationDatetime
     */
    public void setVerificationDate(String input) {
        setElement(input, 28);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of VerificationDatetime
     */
    public String getVerificationDate() {
        return getElement(28);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of VerificationBy
     */
    public void setVerificationBy(String input) {
        setElement(input, 29);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of VerificationBy
     */
    public String getVerificationBy() {
        return getElement(29);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of AgreementCodeType
     */
    public void setAgreementCodeType(String input) {
        setElement(input, 30);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of AgreementCodeType
     */
    public String getAgreementCodeType() {
        return getElement(30);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of BillingStatus
     */
    public void setBillingStatus(String input) {
        setElement(input, 31);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of BillingStatus
     */
    public String getBillingStatus() {
        return getElement(31);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of LifetimeReserveDays
     */
    public void setLifetimeReserveDays(String input) {
        setElement(input, 32);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of LifetimeReserveDays
     */
    public String getLifetimeReserveDays() {
        return getElement(32);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of DelayBeforeLRDay
     */
    public void setDelayBeforeLRDay(String input) {
        setElement(input, 33);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of DelayBeforeLRDay
     */
    public String getDelayBeforeLRDay() {
        return getElement(33);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @param input
     *            A value of CompanyPlanCode
     */
    public void setCompanyPlanCode(String input) {
        setElement(input, 34);
    }

    /**
     * 
     * NOT USED (VISTA Messaging HL7)
     * 
     * @return String A value of CompanyPlanCode
     */
    public String getCompanyPlanCode() {
        return getElement(34);
    }

    /**
     * 
     * INSURANCE NUMBER (#2.312) (1)
     * 
     * @param input
     *            A value of PolicyNumber
     */
    public void setPolicyNumber(String input) {
        setElement(input, 35);
    }

    /**
     * 
     * INSURANCE NUMBER (#2.312) (1)
     * 
     * @return String A value of PolicyNumber
     */
    public String getPolicyNumber() {
        return getElement(35);
    }
    
}