/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

// Framework classes
import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A FT1 segment containing information about batch trailer
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class FT1 extends Segment {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7523056552892401035L;

	/**
     * Constructs an empty segment. This constructor is ususally usd by derived
     * segment classes to populate its own segment data.
     */
    public FT1() {
        super();
        setName(SegmentConstants.FT1);
    }

    /**
     * Constructs a segment of elements from a raw data string. This constructor
     * is usually used to construct an inbound message from a raw message's
     * segment data.
     * 
     * @param data
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public FT1(String data) throws InvalidSegmentException {
        super(data);
    }

    /**
     * Constructs a segment of elements from a raw data string, an array of
     * valid encoding character strings, and a element delimiter string. This
     * constructor is usually used to construct an inbound message from a raw
     * message's segment data, a specific encoding characters, and a field
     * delimiter.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentData
     *            A raw data string
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public FT1(String[] encodingChars, String elementDelimiter,
            String segmentData) throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentData);
    }

    /**
     * Constructs a segment from a segment name and a list of elements. This
     * constructor is usually used to construct an outbound message from a list
     * of specific segment elements, and a segment name.
     * 
     * @param name
     *            A segment name
     * @param elements
     *            A list of segment elements
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public FT1(String name, List elements) throws InvalidSegmentException {
        super(name, elements);
    }

    /**
     * Constructs a segment from an array of encoding characters, a field
     * delimiter, a segment name, and a list of field data. This constructor is
     * usually used to construct an outbound message from a list of specific
     * segment elements, element delimiter, and encoding characters.
     * 
     * @param encodingChars
     *            An array of encoding characters
     * @param elementDelimiter
     *            A field delimiter
     * @param segmentName
     *            A segment name
     * @param segmentElements
     *            A list of field data
     * @throws InvalidSegmentException
     *             Thrown if failed to construct a segment due to missing
     *             parameters or invalid segment data to parse.
     */
    public FT1(String[] encodingChars, String elementDelimiter,
            String segmentName, List segmentElements)
            throws InvalidSegmentException {
        super(encodingChars, elementDelimiter, segmentName, segmentElements);
    }

    /**
     * 
     * SEQUENTIAL NUMBER
     * 
     * @param input
     *            A value of SetID
     */
    public void setSetID(String input) {
        setElement(input, 0);
    }

    /**
     * 
     * SEQUENTIAL NUMBER
     * 
     * @return String A value of SetID
     */
    public String getSetID() {
        return getElement(0);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of TransactionID
     */
    public void setTransactionID(String input) {
        setElement(input, 1);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of TransactionID
     */
    public String getTransactionID() {
        return getElement(1);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of TransactionBatchID
     */
    public void setTransactionBatchID(String input) {
        setElement(input, 2);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of TransactionBatchID
     */
    public String getTransactionBatchID() {
        return getElement(2);
    }

    /**
     * 
     * DATE BILL CREATED (.07) (Precise Date)
     * 
     * @param input
     *            A value of TransactionDate
     */
    public void setTransactionDate(String input) {
        setElement(input, 3);
    }

    /**
     * 
     * DATE BILL CREATED (.07) (Precise Date)
     * 
     * @return String A value of TransactionDate
     */
    public String getTransactionDate() {
        return getElement(3);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of TransactionPostingDate
     */
    public void setTransactionPostingDate(String input) {
        setElement(input, 4);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of TransactionPostingDate
     */
    public String getTransactionPostingDate() {
        return getElement(4);
    }

    /**
     * 
     * If BILL CANCELLED (.11) then 2  CREDIT If DATE BILL CLOSED (.1) AND DATE
     * LAST TRANSMITTED (.13) Then 4 - ADJUSTMENT If AMOUNT COLLECTED (.09) AND
     * DATE LAST TRANSMITTED (.13) Then 3  PAYMENT Else 1  CHARGE
     * 
     * @param input
     *            A value of TransactionType
     */
    public void setTransactionType(String input) {
        setElement(input, 5);
    }

    /**
     * 
     * If BILL CANCELLED (.11) then 2  CREDIT If DATE BILL CLOSED (.1) AND DATE
     * LAST TRANSMITTED (.13) Then 4 - ADJUSTMENT If AMOUNT COLLECTED (.09) AND
     * DATE LAST TRANSMITTED (.13) Then 3  PAYMENT Else 1  CHARGE
     * 
     * @return String A value of TransactionType
     */
    public String getTransactionType() {
        return getElement(5);
    }

    /**
     * 
     * REFERENCE NUMBER (.01)
     * 
     * @param input
     *            A value of TransactionCode
     */
    public void setTransactionCode(String input) {
        setElement(input, 6);
    }

    /**
     * 
     * REFERENCE NUMBER (.01)
     * 
     * @return String A value of TransactionCode
     */
    public String getTransactionCode() {
        return getElement(6);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of TransactionDescription
     */
    public void setTransactionDescription(String input) {
        setElement(input, 7);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of TransactionDescription
     */
    public String getTransactionDescription() {
        return getElement(7);
    }

    /**
     * 
     * 4 Components: CLASSIFICATION (.03), BILL TYPE (.04), BILL FROM .05), BILL
     * TO (.06)
     * 
     * @param input
     *            A value of TransactionDescriptionAlternative
     */
    public void setTransactionDescriptionAlternative(String input) {
        setElement(input, 8);
    }

    /**
     * 
     * 4 Components: CLASSIFICATION (.03), BILL TYPE (.04), BILL FROM .05), BILL
     * TO (.06)
     * 
     * @return String A value of TransactionDescriptionAlternative
     */
    public String getTransactionDescriptionAlternative() {
        return getElement(8);
    }

    /**
     * 
     * NOT USED
     * 
     * @param input
     *            A value of TransactionQuantity
     */
    public void setTransactionQuantity(String input) {
        setElement(input, 9);
    }

    /**
     * 
     * NOT USED
     * 
     * @return String A value of TransactionQuantity
     */
    public String getTransactionQuantity() {
        return getElement(9);
    }

    /**
     * 
     * If DATE BILL CLOSED (.01) AND DATE LAST TRANSMITTED (.13) Then AMOUNT
     * COLLECTED (.09) If AMOUNT COLLECTED (.09) AND DATE LAST TRANSMITTED (.13)
     * Then AMOUNT COLLECTED (.09)
     * 
     * @param input
     *            A value of TransactionAmountExtended
     */
    public void setTransactionAmountExtended(String input) {
        setElement(input, 10);
    }

    /**
     * 
     * If DATE BILL CLOSED (.01) AND DATE LAST TRANSMITTED (.13) Then AMOUNT
     * COLLECTED (.09) If AMOUNT COLLECTED (.09) AND DATE LAST TRANSMITTED (.13)
     * Then AMOUNT COLLECTED (.09)
     * 
     * @return String A value of TransactionAmountExtended
     */
    public String getTransactionAmountExtended() {
        return getElement(10);
    }

    /**
     * 
     * AMOUNT BILLED (.08)
     * 
     * @param input
     *            A value of TransactionAmountUnit
     */
    public void setTransactionAmountUnit(String input) {
        setElement(input, 11);
    }

    /**
     * 
     * AMOUNT BILLED (.08)
     * 
     * @return String A value of TransactionAmountUnit
     */
    public String getTransactionAmountUnit() {
        return getElement(11);
    }
}