/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

// Framework classes
import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * @author DNS   LEV
 * @version 1.0
 */
public class BHS extends Segment {

   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8428575070091894677L;

	/**
    * @param data
    * @throws InvalidSegmentException
    */
   public BHS() {
      super();
      setName( SegmentConstants.BHS );
   }

   /**
    * @param data
    * @throws InvalidSegmentException
    */
   public BHS(String data) throws InvalidSegmentException {
      super(data);
   }

   /**
    * @param encodingChars
    * @param elementDelimiter
    * @param segmentData
    * @throws InvalidSegmentException
    */
   public BHS( String[] encodingChars, 
         			  String elementDelimiter,
         			  String segmentData ) 
   	throws InvalidSegmentException {
      super(encodingChars, elementDelimiter, segmentData);
   }
   
   /**
    * @param name
    * @param elements
    * @throws InvalidSegmentException
    */
   public BHS( String name, 
         			  List elements ) 
   	throws InvalidSegmentException {
      super(name, elements);
   }
   
   /**
    * @param encodingChars
    * @param elementDelimiter
    * @param segmentName
    * @param segmentElements
    * @throws InvalidSegmentException
    */
   public BHS( String[] encodingChars, 
         			  String elementDelimiter,
         			  String segmentName, 
         			  List segmentElements )
   	throws InvalidSegmentException {
      super(encodingChars, elementDelimiter, segmentName, segmentElements);
   }
   
   public void setFieldSeparator( String input ) {
      setElement( input, 0 );
      setElementDelimiter( input );
   }
   
   public String getFieldSeparator() {
      return getElement( 0 );
   }
   
   public void setEncodingCharacters( String input ) {
      setElement( input, 1 );
   }
   
   public String getEncodingCharacters() {
      return getElement( 1 );
   }
   
   public void setSendingApplication( String input ) {
      setElement( input, 2 );
   }
   
   public String getSendingApplication() {
      return getElement( 2 );
   }
   
   public void setSendingFacility( String input ) {
      setElement( input, 3 );
   }
   
   public String getSendingFacility() {
      return getElement( 3 );
   }
   
   public void setReceivingApplication( String input ) {
      setElement( input, 4 );
   }
   
   public String getReceivingApplication() {
      return getElement( 4 );
   }
   
   public void setReceivingFacility( String input ) {
      setElement( input, 5 );
   }
   
   public String getReceivingFacility() {
      return getElement( 5 );
   }
   
   public void setCreationDate( String input ) {
      setElement( input, 6 );
   }
   
   public String getCreationDate() {
      return getElement( 6 );
   }
   
   public void setSecurity( String input ) {
      setElement( input, 7 );
   }
   
   public String getSecurity() {
      return getElement( 7 );
   }
   
   public void setNameIDType( String input ) {
      setElement( input, 8 );
   }
   
   public String getNameIDType() {
       return getElement( 8 );
    }
   
   public void setComment( String input ) {
      setElement( input, 9 );
   }
   
   public String getComment() {
      return getElement( 9 );
   }
   
   public void setControlID( String input ) {
      setElement( input, 10 );
   }
   
   public String getControlID() {
      return getElement( 10 );
   }
   
   public void setReferenceControlID( String input ) {
      setElement( input, 11 );
   }
   
   public String getReferenceControlID() {
      return getElement( 11 );
   }
}