/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.hl7.event;

import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.service.event.ServiceEvent;


/** A message event that encapsulates a message and 
 * an event source.  This message event is a synchronous
 * event, which means its event process is executed on the
 * same thread as an event source.
 * 
 * @author Vu Le
 * @version 1.0
 */
public class MessageEvent extends ServiceEvent {

   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7875252641262214842L;
	/**
    * An instance of a message
    */
   private Message message = null;
   
   
   /** An event generated by the specific source
    * @param source
    */
   public MessageEvent(Object source) {
      this(source, null);
   }

   /** An event generated by the specific source
    * @param source
    */
   public MessageEvent(Object source, Message message ) {
      super(source);
      this.message = message;
   }

   /**
    * @return Returns the message.
    */
   public Message getMessage() {
      return message;
   }
   /**
    * @param message The message to set.
    */
   public void setMessage(Message message) {
      this.message = message;
   }
}
