/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.hl7.event;

// Framework classes
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.service.event.Asynchronous;

;

/** A message event that is processed on a different thread from an
 * event source's thread.  An application listener service listens 
 * to a message event and if an event implements an asynchronous interface,
 * the event processing will be executed on a different thread. 
 * 
 * @author Vu Le
 * @version 1.0
 */
public class AsynchMessageEvent extends MessageEvent implements Asynchronous {

   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 4054698523956029724L;

	/** An event generated by the specific source
    * @param source
    */
   public AsynchMessageEvent(Object source) {
      super( source );
   }

   /** An event generated by the specific source
    * @param source
    */
   public AsynchMessageEvent(Object source, Message message ) {
      super( source, message );
   }
}
