/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.hl7.constants;

/**
 * An interface containing all constants representing common segment names in a
 * HL7 message
 * 
 * @author Vu Le
 * @version 1.0
 */
public interface SegmentConstants {

    /////////////////////////////////
    // Segment SegmentConstants
    //////////////////////////////////

    // BATCH HEADER
    public static final String BHS = "BHS";
    
    // BATCH TRAILER
    public static final String BTS = "BTS";

    // FINANCIAL TRANSACTION
    public static final String FT1 = "FT1";
    
    // INSURANCE SEGMENT
    public static final String IN1 = "IN1";
    
    // MASTER FILE ACKNOWLEDGEMENT
    public static final String MFA = "MFA";
    
    // MASTER FILE ENTRY
    public static final String MFE = "MFE";
    
    // MASTER FILE IDENTIFICATION
    public static final String MFI = "MFI";
    
    // MESSAGE ACKNOWLEDGEMENT
    public static final String MSA = "MSA";

    // MESSAGE HEADER
    public static final String MSH = "MSH";

    // NOTES & COMMENTS
    public static final String NTE = "NTE";
    
    // OBSERVATION/RESULT SEGMENT
    public static final String OBX = "OBX";	

    // PATIENT DEMOGRAPHIC
    public static final String PD1 = "PD1";
    
    // PATIENT IDENTIFICATION SEGMENT
    public static final String PID = "PID";

    // QUERY DEFINITION
    public static final String QRD = "QRD";

    // QUERY FILTER
    public static final String QRF = "QRF";
    
    // REFERRAL INFORMATION SEGMENT
    public static final String RF1 = "RF1";

    // VA SPECIFIC BENEFICIARY TRAVEL SEGMENT
    public static final String ZBT = "ZBT";

    // VA SPECIFIC CATASTROPHIC DISABILITY SEGMENT
    public static final String ZCD = "ZCD";
    
    // VA SPECIFIC EMERGENCY CONTACT
    public static final String ZCT = "ZCT";

    // VA SPECIFIC DEPENDENT INFORMATION SEGMENT
    public static final String ZDP = "ZDP";
    
    // VA SPECIFIC ENROLLMENT GROUP THRESHOLD SEGMENT
    public static final String ZEG = "ZEG";
    
    // VA SPECIFIC ELIGIBILITY SEGMENT
    public static final String ZEL = "ZEL";

    // VA SPECIFIC ELIGIBILITY SEGMENT (For Z11 Only)
    public static final String ZELZ11 = "ZEL";
    
    // VA SPECIFIC EMPLOYMENT INFO SEGMENT
    public static final String ZEM = "ZEM";
    
    // VA SPECIFIC ENROLLMENT SEGMENT
    public static final String ZEN = "ZEN";

    // VA SPECIFIC FEE BASIS SEGMENT
    public static final String ZFE = "ZFE";

    // VA SPECIFIC GUARDIAN SEGMENT
    public static final String ZGD = "ZGD";

    // VA SPECIFIC INCOME SEGMENT
    public static final String ZIC = "ZIC";

    // VA SPECIFIC INELIGIBLE SEGMENT
    public static final String ZIE = "ZIE";

    // VA SPECIFIC PATIENT INFO SEGMENT
    public static final String ZIO = "ZIO";
    
    // VA SPECIFIC INCOME RELATION SEGMENT
    public static final String ZIR = "ZIR";
    
    // VA SPECIFIC MESSAGE PROCESSING SEGMENT
    public static final String ZIV = "ZIV";
        
    // VA SPECIFIC MILITARY HISTORY SEGMENT
    public static final String ZMH = "ZMH";

    // VA INFORMATION SEGMENT
    public static final String ZMT = "ZMT";
    
    // VA SPECIFIC INFO SEGMENT
    public static final String ZPD = "ZPD";
    
    // VA SPECIFIC RATED DISABILITIES SEGMENT
    public static final String ZRD = "ZRD";

    // VA SPECIFIC SERVICE PERIOD SEGMENT
    public static final String ZSP = "ZSP";

    // VA SPECIFIC TEMPORARY ADDRESS SEGMENT
    public static final String ZTA = "ZTA";
    
//  VA SPECIFIC HEALTH BENEFIT PLAN SEGMENT
    public static final String ZHP = "ZHP";
    
    // Addition for seeding messages
    public static final String QPD = "QPD";
    public static final String QAK = "QAK";
    public static final String RCP = "RCP";
    
    //VA SPECIFIC PATIENT ELIGIBILITY SEGMENT
    public static final String ZE2 = "ZE2";
    
    //List of all the HL7 segments
    public static String[] HL7_SEGMENTS_LIST = new String[] { BHS, BTS,
            FT1, IN1, MFA, MFE, MFI, MSA, MSH, NTE,
            OBX, PD1, PID, QRD, QRF, RF1, ZBT, ZCD,
            ZCT, ZDP, ZEG, ZEL, ZEM, ZEN, ZFE, ZGD,
            ZIC, ZIE, ZIO, ZIR, ZIV, ZMH, ZMT, ZPD,
            ZRD, ZSP, ZTA, QPD, QAK, RCP, ZE2, ZHP };
    
    //PID -1 Constants
    public static final String ASSIGNING_AUTHORITY_USVHA = "USVHA";
    public static final String ASSIGNING_AUTHORITY_USSSA = "USSSA";
    public static final String ASSIGNING_AUTHORITY_USVBA = "USVBA";
   
    public static final String ASSIGNING_AUTHORITY_HL7_TABLE = "0363";
    
    public static final String IDENTIFIER_TYPE_NI = "NI";
    public static final String IDENTIFIER_TYPE_SS = "SS";    
    public static final String IDENTIFIER_TYPE_PI = "PI";
    public static final String IDENTIFIER_TYPE_PN = "PN";
    
    public static final String ASSIGNING_LOCATION_VA_FACILITY = "VA FACILITY ID"; 
    
    public static final String ASSIGNING_LOCATION_LOCAL_CODING_SCHEME = "L";
    
    public static final String ASSIGNING_LOCATION_ICN = "200M";
     
    //Address types defined in different RF1s
    public static final String ADDRESS_TYPE_STREET = "SAD";
    public static final String ADDRESS_TYPE_CONFIDENTIAL= "CAD";
    
    //Telecom Use code for email address in PID-13
    public static final String TELECOM_USE_CODE_PAGER = "BPN";
    public static final String TELECOM_USE_CODE_CELL_PHONE = "ORN";
    public static final String TELECOM_USE_CODE_PRIMARY_RESIDENCE = "PRN";
    public static final String TELECOM_USE_CODE_WORK= "WPN";
    public static final String TELECOM_USE_CODE_EMAIL = "NET";
    public static final String TELECOM_EQUIPMENT_EMAIL = "INTERNET"; 
    
    //Referral Codes to be used in outgoing RF1 segment
    public static final String REFERRAL_TYPE_STREET_ADDRESS_CHANGE = "SAD";
    public static final String REFERRAL_TYPE_HOME_PHONE_CHANGE = "PHH";
    public static final String REFERRAL_TYPE_WORK_PHONE_CHANGE = "PHW";
    public static final String REFERRAL_TYPE_CELL_PHONE_CHANGE = "CPH";
    public static final String REFERRAL_TYPE_PAGER_NUMBER_CHANGE = "PNO";
    public static final String REFERRAL_TYPE_EMAIL_ADDRESS_CHANGE = "EAD";
    
    // MSH Constants
    public static final String HINQ = "HNQ";
    public static final String VBA = "VBA";

	public static final String DEFAULT_VALUE = "\"\""; 
    
}