/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.hl7.builder;

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

// Framework classes
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.model.AbstractEntity;

/**
 * @author DNS   LEV
 * @version 1.0
 */
public abstract class AbstractMetaData extends AbstractEntity implements MetaData {

   private static final long serialVersionUID = -1370346746640850300L;
   private AbstractEntity entity = null;
   private Message message = null;
   private Object data = null;
   
   protected Log logger = LogFactory.getLog( getClass() );

   protected AbstractMetaData( AbstractEntity entity ) {
      this.entity = entity; 
   }
   
   protected AbstractMetaData( Message message ) {
      this.message = message; 
   }
   
   protected AbstractMetaData( AbstractEntity entity, Message message ) {
      this.message = message; 
      this.entity = entity;
   }
   
   protected AbstractMetaData( Object data ) {
      this.data = data;
   }
   
   /** Return a business object
    * @return An entity representing a business object
    */
   public AbstractEntity getEntity() {
      return entity;
   }
   
   /**
    * Returns a HL7 message
    * @return A HL7 message
    */
   public Message getMessage() {
      return message;
   }
   
   /**
    * Returns a raw data 
    * @return
    */
   public Object getData() {
      return data;
   }
   
   /**
    * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
    */
   protected void buildToString(ToStringBuilder builder) {
      builder.append( "message", this.message );
      builder.append( "entity", this.entity );
      builder.append( "data", this.data );
   }
   
   /**
    * @see java.lang.Object#finalize()
    */
   protected void finalize() throws Throwable {
      this.entity = null;
      this.data = null;
      this.message = null;
      super.finalize();
   }
}