package gov.va.med.fw.conversion;

// Java classes
import java.util.List;

/**
 * Thye ConversionService interface.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public interface ConversionService 
{	
	/**
	 * Call back method called by the BeanConverter before performing the conversion.
	 * 
	 * @param source the source object
	 * @param target the target object
	 * 
	 * @throws ConversionServiceException when aay error occured during converting.
	 */
	public void preProcessConvert(Object source, Object target)
	throws ConversionServiceException;
	
	/**
	 * The main method where actual conversion happens.
	 * 
	 * @param source the source object
	 * @param target the target object
	 * 
	 * @throws ConversionServiceException when aay error occured during converting.
	 */
	public void convert(Object source, Object target)
	throws ConversionServiceException;
	
	/**
	 * The main method where actual conversion happens. A new target object will be created
	 * 
	 * @param source the source object
	 * @param targetClass the class object of the target
	 * 
	 * @throws ConversionServiceException when aay error occured during converting.
	 */
	public Object convert(Object source, Class targetClass)
	throws ConversionServiceException;
	
	/**
	 * Call back method called by the BeanConverter after performing the conversion.
	 * 
	 * @param source the source object
	 * @param target the target object
	 * 
	 * @throws ConversionServiceException when aay error occured during converting.
	 */
	public void postProcessConvert(Object source, Object target)
	throws ConversionServiceException; 
	
	/**
	 * The merge logic.
	 * 
	 * @see For limitation please refer to BeanConverter javadoc.
	 * 
	 * @param source the source object
	 * @param target the target object
	 * 
	 */
	public void merge(Object source, Object target)
	throws Exception;
	
	/**
	 * Getter for the source property mapping.
	 */
	public List getMappingFile();
	
	/**
	 * Setter for the source property mapping.
	 */
	public void setMappingFile(List mappingFile);
}
