/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.cache;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.service.AbstractComponent;

/**
 * Abstract managment of a cache.  Implementation of cache is delegated
 * to the injected CacheStrategy.
 * 
 * Created Nov 3, 2005 12:25:34 PM
 * @author DNS   BOHMEG
 */
public abstract class AbstractCacheManager extends AbstractComponent 
	implements CacheManager {
    
    private static final long serialVersionUID = -1370346746640850300L;
	private CacheStrategy cacheStrategy;
	
	public Object getItem(Object key) {
		return cacheStrategy.getItem(key);
	}

	public synchronized Object removeItem(Object key) {
		return cacheStrategy.removeItem(key);
	}
	
	public void cacheItem(Object key, Object value) {
		cacheStrategy.cacheItem(key, value);
	}
	
	public boolean containsItem(Object key) {
		return cacheStrategy.containsItem(key);
	}

	public void afterPropertiesSet() {
		Validate.notNull(cacheStrategy);
	}

	/**
	 * @return Returns the cacheStrategy.
	 */
	public CacheStrategy getCacheStrategy() {
		return cacheStrategy;
	}

	/**
	 * @param cacheStrategy The cacheStrategy to set.
	 */
	public void setCacheStrategy(CacheStrategy cacheStrategy) {
		this.cacheStrategy = cacheStrategy;
	}
}
