/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.batchprocess.model;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;


/**
 * Initial javadoc for class JobConfig.
 * 
 * Created Sep 21, 2006 3:47:47 PM
 * @author DNS   BOHMEG
 */
public class JobConfig extends AbstractJob {
	/**
	 * serialVersionUID long
	 */
	private static final long serialVersionUID = 2653206676969781752L;
	private String emailDistributionList;

	/**
	 * @return Returns the emailDistributionList.
	 */
	public String getEmailDistributionList() {
		return emailDistributionList;
	}

	/**
	 * @param emailDistributionList The emailDistributionList to set.
	 */
	public void setEmailDistributionList(String emailDistributionList) {
		this.emailDistributionList = emailDistributionList;
	}
	
	public List getEmailsAsList() {
		List emails = new ArrayList();
		if(StringUtils.isNotBlank(emailDistributionList)) {
			String[] adds = emailDistributionList.split(",");
			for(int i=0; i<adds.length; i++)
				emails.add(adds[i].trim());
		}
		return emails;
	}
}
