/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.batchprocess.model;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Initial javadoc for class AbstractJob.
 * 
 * Created Sep 21, 2006 3:48:11 PM
 * @author DNS   BOHMEG
 */
public class AbstractJob extends AbstractKeyedEntity {
	/**
	 * serialVersionUID long
	 */
	private static final long serialVersionUID = 5069566142788813099L;
	private String jobName;
	private String jobGroup;
	
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("jobName", this.jobName);		
		builder.append("jobGroup", this.jobGroup);
	}	

	/**
	 * @return Returns the jobName.
	 */
	public String getJobName() {
		return jobName;
	}

	/**
	 * @param jobName The jobName to set.
	 */
	public void setJobName(String jobName) {
		this.jobName = jobName;
	}

	/**
	 * @return Returns the jobGroup.
	 */
	public String getJobGroup() {
		return jobGroup;
	}

	/**
	 * @param jobGroup The jobGroup to set.
	 */
	public void setJobGroup(String jobGroup) {
		this.jobGroup = jobGroup;
	}
}
