/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.batchprocess;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * Convenience class for DataQueryProcess instances that acquireData
 * based on a target date.
 * 
 * Created Apr 14, 2006 11:54:22 AM
 * @author DNS   BOHMEG
 */
public class TargetDateQueryProcessStatistics extends
		DataQueryProcessStatistics {
	/**
	 * serialVersionUID long
	 */
	private static final long serialVersionUID = -1573863664238321304L;
	private Date targetDate;

	/**
	 * @return Returns the targetDate.
	 */
	public Date getTargetDate() {
		return targetDate;
	}

	/**
	 * @param targetDate The targetDate to set.
	 */
	public void setTargetDate(Date targetDate) {
		this.targetDate = targetDate;
	}
	
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("targetDate", targetDate);
	}
}
