/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.batchprocess;

import java.util.Iterator;
import java.util.List;

/**
 * Simple implementation that simply puts acquired data into 
 * processed bucket in context.
 * 
 * Created Mar 6, 2006 11:07:14 AM
 * @author DNS   BOHMEG
 */
public class SimpleDataQueryAcquisitionProcess extends
	AbstractDataQueryProcess {	
	private boolean shouldManageStatistics = true;

	/* (non-Javadoc)
	 * @see gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess#processData(gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext, java.util.List)
	 */
	protected final void processData(DataProcessExecutionContext context,
			List acquiredData) {
		Iterator itr = acquiredData != null ? acquiredData.iterator() : null;
		while(itr != null && itr.hasNext()) {
			context.getProcessedData().add(itr.next());
			if(shouldManageStatistics) {
				// this assumes the injected DataProcessCompletedHandler (if any) will not error out
				context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
			}
		}
	}
	
	/**
	 * @return Returns the shouldManageStatistics.
	 */
	public boolean isShouldManageStatistics() {
		return shouldManageStatistics;
	}

	/**
	 * @param shouldManageStatistics The shouldManageStatistics to set.
	 */
	public void setShouldManageStatistics(boolean shouldManageStatistics) {
		this.shouldManageStatistics = shouldManageStatistics;
	}
}
