package gov.va.med.fw.batchprocess;


import gov.va.med.fw.io.writer.FormattedFileWriter;

import java.util.ArrayList;

// write stats to a file
public class ProcessStatisticsWriter extends ProcessStatisticsMailer {

	private FormattedFileWriter  statisticsWriter;
	
	public FormattedFileWriter getStatisticsWriter() {
		return statisticsWriter;
	}

	public void setStatisticsWriter(FormattedFileWriter statisticsWriter) {
		this.statisticsWriter = statisticsWriter;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.batchprocess.ProcessStatisticsHandler#processStatistics(gov.va.med.fw.batchprocess.ProcessStatistics)
	 */
	protected void doProcessStatistics(ProcessStatistics processStatistics, String subjectReplacementValue, String[] dynamicEmailRecipients) {
		super.doProcessStatistics(processStatistics, subjectReplacementValue, dynamicEmailRecipients);
		
		//now handle writig the statistics to the datafile. 
		if ( statisticsWriter  != null ) {
			ArrayList statslist = new ArrayList();
			statslist.add(processStatistics.toFormattedMailString());
			statisticsWriter.appendData(statslist);
		}
	}

	
}

