/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.batchprocess;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.mail.SimpleMailMessage;

import gov.va.med.fw.mail.MailService;
import gov.va.med.fw.service.AbstractComponent;

/**
 * Initial javadoc for class ProcessStatisticsMailer.
 * TODO - Add content here
 * 
 * Created Feb 6, 2006 9:43:08 AM
 * @author DNS   BOHMEG
 */
public class ProcessStatisticsMailer extends AbstractComponent implements
		ProcessStatisticsHandler {
	public static String DEFAULT_SUBJECT_REPLACEMENT_TOKEN = "@subject@";
	private MailService mailService;
	private SimpleMailMessage messageTemplate;
	private String subjectReplacementToken = DEFAULT_SUBJECT_REPLACEMENT_TOKEN;
	private boolean ignoreEmptyStatistics = false;

	public void processStatistics(ProcessStatistics processStatistics) {
		processStatistics(processStatistics, processStatistics.getProcessName());
	}
	
	public void processStatisticsWithDynamicRecipients(ProcessStatistics processStatistics, List emailRecipients) {
		doProcessStatistics(processStatistics, processStatistics.getProcessName(), (String[]) emailRecipients.toArray(new String[0]));
	}
	
	public void processStatistics(ProcessStatistics processStatistics, String subjectReplacementValue) {
		doProcessStatistics(processStatistics, subjectReplacementValue, null);
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.batchprocess.ProcessStatisticsHandler#processStatistics(gov.va.med.fw.batchprocess.ProcessStatistics)
	 */
	protected void doProcessStatistics(ProcessStatistics processStatistics, String subjectReplacementValue, String[] dynamicEmailRecipients) {
		if(ignoreEmptyStatistics && processStatistics.getNumberOfTotalRecords() == 0)
			return;
		
		if(messageTemplate.getTo() != null || dynamicEmailRecipients != null) {
			SimpleMailMessage template = messageTemplate;
			if(StringUtils.isNotBlank(subjectReplacementToken) &&
					StringUtils.isNotBlank(messageTemplate.getSubject()) &&
					messageTemplate.getSubject().indexOf(subjectReplacementToken) != -1) {
				template = new SimpleMailMessage(messageTemplate);
				
				String subject = template.getSubject().replaceFirst(subjectReplacementToken, subjectReplacementValue);
				
		        //Filter out carriage return characters to avoid Fortify High finding - Header Manipulation: SMTP
		    	String filteredSubject = subject;
		    	if (StringUtils.isNotEmpty(subject)) {
		    		filteredSubject = filteredSubject.replace("\r", "");
		    		filteredSubject = filteredSubject.replace("\n", "");
		    	}
		    	template.setSubject(filteredSubject);
			}
			
			// use passed-in recipients (if there)
			if(dynamicEmailRecipients != null)
				template.setTo(dynamicEmailRecipients);
			
			mailService.send(processStatistics.toFormattedMailString(), template);
		}
		else {
			if(logger.isWarnEnabled())
				logger.warn("Unable to email ProcessStatistics since there is no recipients configured/passed-in");
		}
	}
	
	public void afterPropertiesSet() {
		Validate.notNull(mailService, "A MailService is required");
		Validate.notNull(messageTemplate, "A messageTemplate is required");
	}

	/**
	 * @return Returns the mailService.
	 */
	public MailService getMailService() {
		return mailService;
	}

	/**
	 * @param mailService The mailService to set.
	 */
	public void setMailService(MailService mailService) {
		this.mailService = mailService;
	}

	/**
	 * @return Returns the messageTemplate.
	 */
	public SimpleMailMessage getMessageTemplate() {
		return messageTemplate;
	}

	/**
	 * @param messageTemplate The messageTemplate to set.
	 */
	public void setMessageTemplate(SimpleMailMessage messageTemplate) {
		this.messageTemplate = messageTemplate;
	}

	/**
	 * @return Returns the subjectReplacementToken.
	 */
	public String getSubjectReplacementToken() {
		return subjectReplacementToken;
	}

	/**
	 * @param subjectReplacementToken The subjectReplacementToken to set.
	 */
	public void setSubjectReplacementToken(String subjectReplacementToken) {
		this.subjectReplacementToken = subjectReplacementToken;
	}

	/**
	 * @return Returns the ignoreEmptyStatistics.
	 */
	public boolean isIgnoreEmptyStatistics() {
		return ignoreEmptyStatistics;
	}

	/**
	 * @param ignoreEmptyStatistics The ignoreEmptyStatistics to set.
	 */
	public void setIgnoreEmptyStatistics(boolean ignoreEmptyStatistics) {
		this.ignoreEmptyStatistics = ignoreEmptyStatistics;
	}
}
