/********************************************************************
 * Copyright  2016 OI&T EPMO. All rights reserved
 ********************************************************************/


package gov.va.med.fw.batchprocess;

import java.util.Map;

import org.apache.commons.lang.builder.ToStringBuilder;


public class Import1095BResponsesPDFProcessStatistics extends DataFileProcessStatistics {


	private static final long serialVersionUID = -1784727060006544163L;
	private int num1095BsStored = 0;
	private int num1095BLettersStored = 0;
	
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
        builder.append("Number of 1095Bs Stored in VBR", num1095BsStored);
		builder.append("Number of 1095B Letters Stored in VBR", num1095BLettersStored);
	}
	
	//Getters, setters and incrementers
	
	public int getNum1095BsStored() {
		return num1095BsStored;
	}

	public void setNum1095BsStored(int num1095BsStored) {
		this.num1095BsStored = num1095BsStored;
	}
	
	public void incrementNum1095BsStored() {
		this.num1095BsStored = this.num1095BsStored + 1;
	}

	public int getNum1095BLettersStored() {
		return num1095BLettersStored;
	}

	public void setNum1095BLettersStored(int num1095bLettersStored) {
		num1095BLettersStored = num1095bLettersStored;
	}	

	public void incrementNum1095BLettersStored() {
		this.num1095BLettersStored = this.num1095BLettersStored + 1;
	}

	@SuppressWarnings("unchecked")
	public Map<String, Integer> statsMap() throws Exception {
		Map<String, Integer> data = super.statsMap();
		
		data.put("Number of 1095Bs Stored in VBR", new Integer(num1095BsStored));
		data.put("Number of 1095B Letters Stored in VBR", new Integer(num1095BLettersStored));
		return data;
	}
}
