/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.batchprocess;

import java.util.Map;

import org.apache.commons.lang.builder.ToStringBuilder;


public class HealthBenefitsPlanProcessStatistics extends DataFileProcessStatistics {


	private static final long serialVersionUID = -1784727060006544163L;
	private int numHandBooksStored = 0;
	private int numBenefitsProfilesStored = 0;
	
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
        builder.append("Number of Handbooks Stored in VBR", numHandBooksStored);
		builder.append("Number of Benefits Profiles Stored in VBR", numBenefitsProfilesStored);
	}
	

	public int getNumBenefitsProfilesStored() {
		return numBenefitsProfilesStored;
	}


	public void setNumBenefitsProfilesStored(int numBenefitsProfilesStored) {
		this.numBenefitsProfilesStored = numBenefitsProfilesStored;
	}
	
	public void incrementNumBenefitsProfilesStored() {
		this.numBenefitsProfilesStored = this.numBenefitsProfilesStored+1;
	}

	public int getNumHandBooksStored() {
		return numHandBooksStored;
	}


	public void setNumHandBooksStored(int numHandBooksStored) {
		this.numHandBooksStored = numHandBooksStored;
	}
	
	public void incrementNumHandbooksStored() {
		this.numHandBooksStored = this.numHandBooksStored+1;
	}


	public Map statsMap() throws Exception {
		Map data = super.statsMap();
		
		data.put("Number of Handbooks Stored in VBR", new Integer(numHandBooksStored));
		data.put("Number of Benefits Profiles Stored in VBR", new Integer(numBenefitsProfilesStored));
		return data;
	}
}
