package gov.va.med.fw.batchprocess;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
/*
*
*/

public class HandbookMailingResponseErrorFileProcessStatistics
             extends DataFileProcessStatistics {



	private static final long serialVersionUID = -1744727060006544164L;

	
	private String processedFilePath;
	private List processedFiles = new ArrayList();
	
	private int numH400HRecordsProcessed = 0;
	private int numH400BRecordsProcessed = 0;
	private int numH400FRecordsProcessed = 0;
	private StringBuffer errorH400HReason = new StringBuffer();
	private StringBuffer errorH400BReason = new StringBuffer();
	private StringBuffer errorH400FReason = new StringBuffer();

	public ProcessStatistics createProcessStatistics() {
		return new HandbookMailingResponseErrorFileProcessStatistics();
    }    
	    
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
        builder.append("Number of F400H Records Processed", numH400HRecordsProcessed);
		builder.append("Number of F400B Records Processed", numH400BRecordsProcessed);
		builder.append("Number of F400F Records Processed", numH400FRecordsProcessed);
		builder.append("List of F400H Reason(s)", errorH400HReason.toString());
		builder.append("List of F400B Reason(s)", errorH400BReason.toString());
		builder.append("List of F400F Reason(s)", errorH400FReason.toString());
	}
				
	public void appendH400HReason(String reason) {
		if (this.errorH400HReason.indexOf(reason) == -1)
		         this.errorH400HReason.append(reason+"^");
	}
	
	public void appendH400BReason(String reason) {
		if (this.errorH400BReason.indexOf(reason) == -1)
		         this.errorH400BReason.append(reason+"^");
	}
	public void appendH400FReason(String reason) {
		if (this.errorH400FReason.indexOf(reason) == -1)
		         this.errorH400FReason.append(reason+"^");
	}	

	
//400B	
	public int getH400BRecords() {
		return numH400BRecordsProcessed;
	}	
	public void setH400BRecordsProcessed(int numH400BRecordsProcessed) {
		this.numH400BRecordsProcessed = numH400BRecordsProcessed;
	}	
	public void incrementH400BRecords() {
		this.numH400BRecordsProcessed = this.numH400BRecordsProcessed+1;
	}
	
//400F	
	public int getH400FRecords() {
		return numH400FRecordsProcessed;
	}
	public void setH400FRecordsProcessed(int numH400FRecordsProcessed) {
		this.numH400FRecordsProcessed = numH400FRecordsProcessed;
	}	
	public void incrementH400FRecords() {
		this.numH400FRecordsProcessed = this.numH400FRecordsProcessed+1;
	}
	
//400H
	public int getH400HRecords() {
		return numH400HRecordsProcessed;
	}
	public void setH400HRecordsProcessed(int numRecordsProcessed) {
		this.numH400HRecordsProcessed = numRecordsProcessed;
	}	
	public void incrementH400HRecordsProcessed() {
		this.numH400HRecordsProcessed  = this.numH400HRecordsProcessed +1;
	}


	public Map statsMap() throws Exception {
		Map data = super.statsMap();		
		data.put("Number of F400H Records Processed", new Integer(numH400HRecordsProcessed ));
		data.put("Number of F400B Records Processed", new Integer(numH400BRecordsProcessed));
		data.put("Number of F400F Records Processed", new Integer(numH400FRecordsProcessed));
		return data;
	}
	
	public Map mapFromCSV(String csv) {
		Map data = super.mapFromCSV(csv);
		String processFilesStr = (String) data.get("processedFiles");
		if(StringUtils.isNotBlank(processFilesStr))
			data.put("processedFiles", super.listFromString(processFilesStr));
		return data;
	}	
	
	// try this test for class cast
	public void appendStats(ProcessStatistics stats) {
		DataFileProcessStatistics _stats = (DataFileProcessStatistics)stats;
		this.setProcessName(_stats.getProcessName());
		this.setProcessedFilePath(_stats.getProcessedFilePath());
		this.setProcessingStartDate(_stats.getProcessingStartDate());
		this.setExecutedOnServer(_stats.getExecutedOnServer());
		this.setProcessedFiles(_stats.getProcessedFiles());
	}
	
	
}
