package gov.va.med.fw.batchprocess;

import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
/* 
 * SUC62.4.4 The system captures and stores the following statistics that will be used to generate a report:
   Date/Time File Received
   File Name
   Number of Error Records Per File
   Break out the letters communication by type and how many per type
   For each letter communication type, the error reason
 * SUC62.4.5 There will only be one Code 1 Reject Reason for each lettercommunication.
   updated 
*/

public class HandbookMailingResponseCode1RejectFileProcessStatistics
             extends DataFileProcessStatistics {



	private static final long serialVersionUID = -1744727060006544165L;
	private int numH400HRecordsProcessed = 0;
	private int numH400BRecordsProcessed = 0;
	private int numH400FRecordsProcessed = 0;
	private StringBuffer errorH400HReason = new StringBuffer();
	private StringBuffer errorH400BReason = new StringBuffer();
	private StringBuffer errorH400FReason = new StringBuffer();
	
	protected ProcessStatistics createProcessStatistics() {
        return new HandbookMailingResponseCode1RejectFileProcessStatistics();
    }    
	    
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
        builder.append("Number of H400H Records Processed", numH400HRecordsProcessed);
		builder.append("Number of H400B Records Processed", numH400BRecordsProcessed);
		builder.append("Number of H400F Records Processed", numH400FRecordsProcessed);
		builder.append("List of H400H Reason(s)", errorH400HReason.toString());
		builder.append("List of H400B Reason(s)", errorH400BReason.toString());
		builder.append("List of H400F Reason(s)", errorH400FReason.toString());
	}
	
	public void appendH400HReason(String reason) {
		if (this.errorH400HReason.indexOf(reason) == -1)
		         this.errorH400HReason.append(reason+"^");
	}
	
	public void appendH400BReason(String reason) {
		if (this.errorH400BReason.indexOf(reason) == -1)
		         this.errorH400BReason.append(reason+"^");
	}
	public void appendH400FReason(String reason) {
		if (this.errorH400FReason.indexOf(reason) == -1)
		         this.errorH400FReason.append(reason+"^");
	}	

	
//400B	
	public int getH400BRecords() {
		return numH400BRecordsProcessed;
	}	
	public void setH400BRecordsProcessed(int numH400BRecordsProcessed) {
		this.numH400BRecordsProcessed = numH400BRecordsProcessed;
	}	
	public void incrementH400BRecords() {
		this.numH400BRecordsProcessed = this.numH400BRecordsProcessed+1;
	}
	
//400F	
	public int getH400FRecords() {
		return numH400FRecordsProcessed;
	}
	public void setH400FRecordsProcessed(int numH400FRecordsProcessed) {
		this.numH400FRecordsProcessed = numH400FRecordsProcessed;
	}	
	public void incrementH400FRecords() {
		this.numH400FRecordsProcessed = this.numH400FRecordsProcessed+1;
	}
	
//400H
	public int getH400HRecords() {
		return numH400HRecordsProcessed;
	}
	public void setH400HRecordsProcessed(int numRecordsProcessed) {
		this.numH400HRecordsProcessed = numRecordsProcessed;
	}	
	public void incrementH400HRecordsProcessed() {
		this.numH400HRecordsProcessed  = this.numH400HRecordsProcessed +1;
	}


	public Map statsMap() throws Exception {
		Map data = super.statsMap();		
		data.put("Number of H400H Records Processed", new Integer(numH400HRecordsProcessed ));
		data.put("Number of H400B Records Processed", new Integer(numH400BRecordsProcessed));
		data.put("Number of H400F Records Processed", new Integer(numH400FRecordsProcessed));
		return data;
	}
	// try this test for class cast
	public void appendStats(ProcessStatistics stats) {
		DataFileProcessStatistics _stats = (DataFileProcessStatistics)stats;
		this.setProcessName(_stats.getProcessName());
		this.setProcessedFilePath(_stats.getProcessedFilePath());
		this.setProcessingStartDate(_stats.getProcessingStartDate());
		this.setExecutedOnServer(_stats.getExecutedOnServer());
		this.setProcessedFiles(_stats.getProcessedFiles());
	}
	
}
