package gov.va.med.fw.batchprocess;


import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
/*
 * Processing Date: Date Of Processing
 * Processed file(s): CMS_address_file_timestamp.txt
 * (Number of Records Processed: total
 * Number of Error Records: total
 * Number of Successful records processed: total
 * 2.6.15 of the ESR_CMS_Interface_Control_Document.doc
*/

public class HandbookMailingResponseAddressFileProcessStatistics
             extends DataFileProcessStatistics {



	private static final long serialVersionUID = -1744727060006544163L;
	
	private int numH400HRecordsProcessed = 0;
	private int numH400BRecordsProcessed = 0;
	private int numH400FRecordsProcessed = 0;
    
	protected ProcessStatistics createProcessStatistics() {
        return new HandbookMailingResponseAddressFileProcessStatistics ();
    }    
	    
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
        builder.append("Number of H400H Records Processed", numH400HRecordsProcessed);
		builder.append("Number of H400B Records Processed", numH400BRecordsProcessed);
		builder.append("Number of H400F Records Processed", numH400FRecordsProcessed);
	}
	
	public int getH400HRecords() {
		return this.numH400BRecordsProcessed;
	}
	
	public void incrementH400BRecords() {
		this.numH400BRecordsProcessed = this.numH400BRecordsProcessed+1;
	}	

	public void setErrorRecordsProcessed(int numErrorRecordsProcessed) {
		this.numH400BRecordsProcessed = numH400BRecordsProcessed;
	}
	
	public int getH400FRecords() {
		return numH400FRecordsProcessed;
	}


	public void setSuccessRecordsProcessed(int numH400FRecordsProcessed) {
		this.numH400FRecordsProcessed = numH400FRecordsProcessed;
	}
	
	public void incrementH400FRecords() {
		this.numH400FRecordsProcessed = this.numH400FRecordsProcessed+1;
	}

	public int getRecordsProcessed() {
		return numH400HRecordsProcessed;
	}


	public void setH400HRecordsProcessed(int numRecordsProcessed) {
		this.numH400HRecordsProcessed = numRecordsProcessed;
	}
	
	public void incrementH400HRecordsProcessed() {
		this.numH400HRecordsProcessed  = this.numH400HRecordsProcessed +1;
	}


	public Map statsMap() throws Exception {
		Map data = super.statsMap();		
		data.put("Number of H400H Records Processed", new Integer(numH400HRecordsProcessed ));
		data.put("Number of H400B Records Processed", new Integer(numH400BRecordsProcessed));
		data.put("Number of H400F Records Processed", new Integer(numH400FRecordsProcessed));
		return data;
	}
	// try this test for class cast
	public void appendStats(ProcessStatistics stats) {
		DataFileProcessStatistics _stats = (DataFileProcessStatistics)stats;
		this.setProcessName(_stats.getProcessName());
		this.setProcessedFilePath(_stats.getProcessedFilePath());
		this.setProcessingStartDate(_stats.getProcessingStartDate());
		this.setExecutedOnServer(_stats.getExecutedOnServer());
		this.setProcessedFiles(_stats.getProcessedFiles());
	}
	
}
