/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.batchprocess;

import java.util.List;

import gov.va.med.fw.persistent.QueryIncrementTracker;

/**
 * Initial javadoc for class DataQueryProcessExecutionContext.
 * TODO - Add content here
 * 
 * Created Feb 17, 2006 3:34:14 PM
 * @author DNS   BOHMEG
 */
public class DataQueryProcessExecutionContext extends
		DataProcessExecutionContext implements QueryIncrementTracker {
	/**
	 * serialVersionUID long
	 */
	private static final long serialVersionUID = 5539533078430740434L;
	private int currentRecord;
	private DataQueryDetail currentDataQuery;

	/**
	 * @return Returns the currentRecord.
	 */
	public int getCurrentRecord() {
		return currentRecord;
	}

	/**
	 * @param currentRecord The currentRecord to set.
	 */
	public void setCurrentRecord(int currentRecord) {
		this.currentRecord = currentRecord;
	}

	/**
	 * @return Returns the currentDataQuery.
	 */
	public DataQueryDetail getCurrentDataQuery() {
		return currentDataQuery;
	}

	/**
	 * @param currentDataQuery The currentDataQuery to set.
	 */
	public void setCurrentDataQuery(DataQueryDetail currentDataQuery) {
		this.currentDataQuery = currentDataQuery;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.persistent.QueryIncrementTracker#getIncrementalData()
	 */
	public List getIncrementalData() {
		return getProcessedData();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.persistent.QueryIncrementTracker#setIncrementalData(java.util.List)
	 */
	public void setIncrementalData(List data) {
		setProcessedData(data);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.persistent.QueryIncrementTracker#getTotalRecords()
	 */
	public int getTotalRecords() {
		return getProcessStatistics().getNumberOfTotalRecords();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.persistent.QueryIncrementTracker#setTotalRecords(int)
	 */
	public void setTotalRecords(int i) {
		this.getProcessStatistics().setNumberOfTotalRecords(i);
	}
}
