/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.batchprocess;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.persistent.QueryInfo;
import gov.va.med.fw.service.AbstractComponent;

/**
 * Details specific information regarding a data query.
 * 
 * Created Apr 24, 2006 2:29:38 PM
 * @author DNS   BOHMEG
 */
public class DataQueryDetail extends AbstractComponent {
	private QueryInfo query;
	private boolean incremental;
	private AcquiredDataProcessor processor;
    
	/**
	 * @return Returns the incremental.
	 */
	public boolean isIncremental() {
		return incremental;
	}
	/**
	 * @param incremental The incremental to set.
	 */
	public void setIncremental(boolean incremental) {
		this.incremental = incremental;
	}
	/**
	 * @return Returns the processor.
	 */
	public AcquiredDataProcessor getProcessor() {
		return processor;
	}
	/**
	 * @param processor The processor to set.
	 */
	public void setProcessor(AcquiredDataProcessor processor) {
		this.processor = processor;
	}
	
	public void afterPropertiesSet() {
		Validate.notNull(query, "A query must be present");
	}

	/**
	 * @return Returns the query.
	 */
	public QueryInfo getQuery() {
		if(query == null)
			query = new QueryInfo();
		return query;
	}

	/**
	 * @param query The query to set.
	 */
	public void setQuery(QueryInfo query) {
		this.query = query;
	}
	
	/* these ease in Spring configuration setting of properties */
	public void setQueryName(String queryName) {
		getQuery().setQuery(queryName);
	}
	public void setParamNames(String[] paramNames) {
		getQuery().setParamNames(paramNames);
	}
	public void setParamValues(Object[] paramValues) {
		getQuery().setParamValues(paramValues);
	}	
}
