/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.fw.batchprocess;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * Initial javadoc for class DataFileProcessStatistics.
 * TODO - Add content here
 * 
 * Created Feb 3, 2006 1:49:05 PM
 * @author DNS   BOHMEG
 */
public class DataFileProcessStatistics extends ProcessStatistics {
	/**
	 * serialVersionUID long
	 */
	private static final long serialVersionUID = 8435464655303251784L;
	private String processedFilePath;
	private List processedFiles = new ArrayList();

	
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
        builder.append("processedFilePath", processedFilePath);
		builder.append("processedFiles", processedFiles);
	}
	
    /**
	 * @return Returns the processedFilePath.
	 */
	public String getProcessedFilePath() {
		return processedFilePath;
	}


	/**
	 * @param processedFilePath The processedFilePath to set.
	 */
	public void setProcessedFilePath(String processedFilePath) {
		this.processedFilePath = processedFilePath;
	}

	/**
	 * @return Returns the processedFiles.
	 */
	public List getProcessedFiles() {
		return processedFiles;
	}


	/**
	 * @param processedFiles The processedFiles to set.
	 */
	public void setProcessedFiles(List processedFiles) {
		this.processedFiles = processedFiles;
	}
	
	/**
	 * @param processedFiles The processedFiles to set.
	 */
	public void addProcessedFile(String processedFiles) {
		this.processedFiles.add(processedFiles);
	}
	
	public Map statsMap() throws Exception {
		Map data = super.statsMap();
		if(!processedFiles.isEmpty())
			data.put("processedFiles", super.listAsString(getProcessedFiles()));
		else
			data.remove("processedFiles");
		return data;
	}
	
	protected Map mapFromCSV(String csv) {
		Map data = super.mapFromCSV(csv);
		String processFilesStr = (String) data.get("processedFiles");
		if(StringUtils.isNotBlank(processFilesStr))
			data.put("processedFiles", super.listFromString(processFilesStr));
		return data;
	}
	
	protected void appendStats(ProcessStatistics stats) {
		this.setProcessedFilePath(((DataFileProcessStatistics) stats).getProcessedFilePath());
		this.getProcessedFiles().addAll(((DataFileProcessStatistics) stats).getProcessedFiles());
	}	
}
