package gov.va.med.fw.batchprocess;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
/*
*
*/

public class CampLejeuneImportProcessStatistics
             extends DataFileProcessStatistics {

	private static final long serialVersionUID = -668691275608266023L;
	
	private StringBuffer summary = new StringBuffer(REPORT_HEADER);
	private StringBuffer detailSuccess = new StringBuffer(REPORT_HEADER).append("OldPriorityGroup").append(DELIMITER).append("NewPriorityGroup").append(LINE_BREAK);
	private StringBuffer detailUnsuccess = new StringBuffer(REPORT_HEADER).append("ErrorReason").append(LINE_BREAK);	
	
	public static final String REPORT_HEADER = "ICN|FirstName|LastName|SSN|DOB|Gender|";
	public static final String LINE_BREAK = "\n";
	public static final String DELIMITER = "|";
	public static final String REASON_FAILED = "ReasonFailed";
	   
	/*
	 * override this so that the long detail success/unsuccess string will be excluded. Otherwise it will overflow the JOB_RESULT.JOB_STATISTICS and 
	 * causes a wired exception: ORA-01461: can bind a LONG value only for insert into a LONG column
	 */    
	/** can be overridden by subclasses for special handling */
	public Map statsMap() throws Exception {
		Map data = BeanUtils.describe(this);
		data.remove("detailSuccess"); //exclude
		data.remove("detailUnsuccess"); //exclude
		
		formatDateField(data, "processingStartDate", getProcessingStartDate());
		formatDateField(data, "processingEndDate", getProcessingEndDate());
		data.remove("class");
		return data;
	}
	
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
        builder.append("Counts of Successful Processed: ", getNumberOfSuccessfulRecords());
		builder.append("Counts of Unsuccessful Processed: ", getNumberOfErrorRecords());
		builder.append("Counts of Total Processed: ", getNumberOfTotalRecords());
	}
		
	public String getDetailSuccess()
	{
		return detailSuccess.toString();
	}
	
	public String getDetailUnsuccess()
	{
		return detailUnsuccess.toString();
	}
	
	public synchronized void addDetailSuccess(String idData, String oldPriGrp, String newPriGrp) {
		this.detailSuccess.append(idData).append(DELIMITER).append(oldPriGrp).append(DELIMITER).append(newPriGrp).append(LINE_BREAK);
	}
	
	
	public synchronized void addDetailUnsuccess(String idData, String errReason) {
		this.detailUnsuccess.append(idData).append(DELIMITER).append(StringUtils.remove(errReason, LINE_BREAK)).append(this.LINE_BREAK);
	}
	


}
